<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankPaymentResponseType StructType
 * @subpackage Structs
 */
class BankPaymentResponseType extends AbstractStructBase
{
    /**
     * The Status
     * @var \StructType\StatusType
     */
    public $Status;
    /**
     * The Redirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RedirectResponseType
     */
    public $Redirect;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InstructionsResponseType
     */
    public $Instructions;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for BankPaymentResponseType
     * @uses BankPaymentResponseType::setStatus()
     * @uses BankPaymentResponseType::setRedirect()
     * @uses BankPaymentResponseType::setInstructions()
     * @uses BankPaymentResponseType::setUserDefinedFields()
     * @param \StructType\StatusType $status
     * @param \StructType\RedirectResponseType $redirect
     * @param \StructType\InstructionsResponseType $instructions
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct(\StructType\StatusType $status = null, \StructType\RedirectResponseType $redirect = null, \StructType\InstructionsResponseType $instructions = null, array $userDefinedFields = array())
    {
        $this
            ->setStatus($status)
            ->setRedirect($redirect)
            ->setInstructions($instructions)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get Status value
     * @return \StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\StatusType $status
     * @return \StructType\BankPaymentResponseType
     */
    public function setStatus(\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectResponseType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectResponseType $redirect
     * @return \StructType\BankPaymentResponseType
     */
    public function setRedirect(\StructType\RedirectResponseType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Instructions value
     * @return \StructType\InstructionsResponseType|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }
    /**
     * Set Instructions value
     * @param \StructType\InstructionsResponseType $instructions
     * @return \StructType\BankPaymentResponseType
     */
    public function setInstructions(\StructType\InstructionsResponseType $instructions = null)
    {
        $this->Instructions = $instructions;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankPaymentResponseTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$bankPaymentResponseTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($bankPaymentResponseTypeUserDefinedFieldsItem) ? get_class($bankPaymentResponseTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($bankPaymentResponseTypeUserDefinedFieldsItem), var_export($bankPaymentResponseTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\BankPaymentResponseType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\BankPaymentResponseType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
}
