<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SinglePaymentResponse StructType
 * @subpackage Structs
 */
class SinglePaymentResponse extends AbstractStructBase
{
    /**
     * The CardPaymentResponse
     * Meta information extracted from the WSDL
     * - choice: CardPaymentResponse | WebPaymentResponse | TokenPaymentResponse | BankPaymentResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardPaymentResponseType
     */
    public $CardPaymentResponse;
    /**
     * The WebPaymentResponse
     * Meta information extracted from the WSDL
     * - choice: CardPaymentResponse | WebPaymentResponse | TokenPaymentResponse | BankPaymentResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WebPaymentResponseType
     */
    public $WebPaymentResponse;
    /**
     * The TokenPaymentResponse
     * Meta information extracted from the WSDL
     * - choice: CardPaymentResponse | WebPaymentResponse | TokenPaymentResponse | BankPaymentResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\TokenPaymentResponseType
     */
    public $TokenPaymentResponse;
    /**
     * The BankPaymentResponse
     * Meta information extracted from the WSDL
     * - choice: CardPaymentResponse | WebPaymentResponse | TokenPaymentResponse | BankPaymentResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\BankPaymentResponseType
     */
    public $BankPaymentResponse;
    /**
     * Constructor method for SinglePaymentResponse
     * @uses SinglePaymentResponse::setCardPaymentResponse()
     * @uses SinglePaymentResponse::setWebPaymentResponse()
     * @uses SinglePaymentResponse::setTokenPaymentResponse()
     * @uses SinglePaymentResponse::setBankPaymentResponse()
     * @param \StructType\CardPaymentResponseType $cardPaymentResponse
     * @param \StructType\WebPaymentResponseType $webPaymentResponse
     * @param \StructType\TokenPaymentResponseType $tokenPaymentResponse
     * @param \StructType\BankPaymentResponseType $bankPaymentResponse
     */
    public function __construct(\StructType\CardPaymentResponseType $cardPaymentResponse = null, \StructType\WebPaymentResponseType $webPaymentResponse = null, \StructType\TokenPaymentResponseType $tokenPaymentResponse = null, \StructType\BankPaymentResponseType $bankPaymentResponse = null)
    {
        $this
            ->setCardPaymentResponse($cardPaymentResponse)
            ->setWebPaymentResponse($webPaymentResponse)
            ->setTokenPaymentResponse($tokenPaymentResponse)
            ->setBankPaymentResponse($bankPaymentResponse);
    }
    /**
     * Get CardPaymentResponse value
     * @return \StructType\CardPaymentResponseType|null
     */
    public function getCardPaymentResponse()
    {
        return isset($this->CardPaymentResponse) ? $this->CardPaymentResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardPaymentResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardPaymentResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardPaymentResponseForChoiceConstraintsFromSetCardPaymentResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WebPaymentResponse',
            'TokenPaymentResponse',
            'BankPaymentResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardPaymentResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: CardPaymentResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardPaymentResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardPaymentResponseType $cardPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setCardPaymentResponse(\StructType\CardPaymentResponseType $cardPaymentResponse = null)
    {
        // validation for constraint: choice(CardPaymentResponse, WebPaymentResponse, TokenPaymentResponse, BankPaymentResponse)
        if ('' !== ($cardPaymentResponseChoiceErrorMessage = self::validateCardPaymentResponseForChoiceConstraintsFromSetCardPaymentResponse($cardPaymentResponse))) {
            throw new \InvalidArgumentException($cardPaymentResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardPaymentResponse) || (is_array($cardPaymentResponse) && empty($cardPaymentResponse))) {
            unset($this->CardPaymentResponse);
        } else {
            $this->CardPaymentResponse = $cardPaymentResponse;
        }
        return $this;
    }
    /**
     * Get WebPaymentResponse value
     * @return \StructType\WebPaymentResponseType|null
     */
    public function getWebPaymentResponse()
    {
        return isset($this->WebPaymentResponse) ? $this->WebPaymentResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWebPaymentResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWebPaymentResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWebPaymentResponseForChoiceConstraintsFromSetWebPaymentResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentResponse',
            'TokenPaymentResponse',
            'BankPaymentResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WebPaymentResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: WebPaymentResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WebPaymentResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebPaymentResponseType $webPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setWebPaymentResponse(\StructType\WebPaymentResponseType $webPaymentResponse = null)
    {
        // validation for constraint: choice(CardPaymentResponse, WebPaymentResponse, TokenPaymentResponse, BankPaymentResponse)
        if ('' !== ($webPaymentResponseChoiceErrorMessage = self::validateWebPaymentResponseForChoiceConstraintsFromSetWebPaymentResponse($webPaymentResponse))) {
            throw new \InvalidArgumentException($webPaymentResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($webPaymentResponse) || (is_array($webPaymentResponse) && empty($webPaymentResponse))) {
            unset($this->WebPaymentResponse);
        } else {
            $this->WebPaymentResponse = $webPaymentResponse;
        }
        return $this;
    }
    /**
     * Get TokenPaymentResponse value
     * @return \StructType\TokenPaymentResponseType|null
     */
    public function getTokenPaymentResponse()
    {
        return isset($this->TokenPaymentResponse) ? $this->TokenPaymentResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTokenPaymentResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTokenPaymentResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTokenPaymentResponseForChoiceConstraintsFromSetTokenPaymentResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentResponse',
            'WebPaymentResponse',
            'BankPaymentResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TokenPaymentResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: TokenPaymentResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TokenPaymentResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TokenPaymentResponseType $tokenPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setTokenPaymentResponse(\StructType\TokenPaymentResponseType $tokenPaymentResponse = null)
    {
        // validation for constraint: choice(CardPaymentResponse, WebPaymentResponse, TokenPaymentResponse, BankPaymentResponse)
        if ('' !== ($tokenPaymentResponseChoiceErrorMessage = self::validateTokenPaymentResponseForChoiceConstraintsFromSetTokenPaymentResponse($tokenPaymentResponse))) {
            throw new \InvalidArgumentException($tokenPaymentResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($tokenPaymentResponse) || (is_array($tokenPaymentResponse) && empty($tokenPaymentResponse))) {
            unset($this->TokenPaymentResponse);
        } else {
            $this->TokenPaymentResponse = $tokenPaymentResponse;
        }
        return $this;
    }
    /**
     * Get BankPaymentResponse value
     * @return \StructType\BankPaymentResponseType|null
     */
    public function getBankPaymentResponse()
    {
        return isset($this->BankPaymentResponse) ? $this->BankPaymentResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBankPaymentResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankPaymentResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBankPaymentResponseForChoiceConstraintsFromSetBankPaymentResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardPaymentResponse',
            'WebPaymentResponse',
            'TokenPaymentResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property BankPaymentResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: BankPaymentResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set BankPaymentResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankPaymentResponseType $bankPaymentResponse
     * @return \StructType\SinglePaymentResponse
     */
    public function setBankPaymentResponse(\StructType\BankPaymentResponseType $bankPaymentResponse = null)
    {
        // validation for constraint: choice(CardPaymentResponse, WebPaymentResponse, TokenPaymentResponse, BankPaymentResponse)
        if ('' !== ($bankPaymentResponseChoiceErrorMessage = self::validateBankPaymentResponseForChoiceConstraintsFromSetBankPaymentResponse($bankPaymentResponse))) {
            throw new \InvalidArgumentException($bankPaymentResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($bankPaymentResponse) || (is_array($bankPaymentResponse) && empty($bankPaymentResponse))) {
            unset($this->BankPaymentResponse);
        } else {
            $this->BankPaymentResponse = $bankPaymentResponse;
        }
        return $this;
    }
}
