<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentType StructType
 * @subpackage Structs
 */
class PaymentType extends AbstractStructBase
{
    /**
     * The Method
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Method;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - base: xs:token
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Detail;
    /**
     * Constructor method for PaymentType
     * @uses PaymentType::setMethod()
     * @uses PaymentType::setDetail()
     * @param string $method
     * @param string $detail
     */
    public function __construct($method = null, $detail = null)
    {
        $this
            ->setMethod($method)
            ->setDetail($detail);
    }
    /**
     * Get Method value
     * @return string
     */
    public function getMethod()
    {
        return $this->Method;
    }
    /**
     * Set Method value
     * @uses \EnumType\PaymentMethodType::valueIsValid()
     * @uses \EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $method
     * @return \StructType\PaymentType
     */
    public function setMethod($method = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentMethodType::valueIsValid($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentMethodType', is_array($method) ? implode(', ', $method) : var_export($method, true), implode(', ', \EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        $this->Method = $method;
        return $this;
    }
    /**
     * Get Detail value
     * @return string|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @param string $detail
     * @return \StructType\PaymentType
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($detail) && mb_strlen($detail) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($detail)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($detail) && mb_strlen($detail) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($detail)), __LINE__);
        }
        $this->Detail = $detail;
        return $this;
    }
}
