<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleVaultResponse StructType
 * @subpackage Structs
 */
class SingleVaultResponse extends AbstractStructBase
{
    /**
     * The CardVaultResponse
     * Meta information extracted from the WSDL
     * - choice: CardVaultResponse | WalletVaultResponse | LookUpVaultResponse | DeleteVaultResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CardVaultResponseType
     */
    public $CardVaultResponse;
    /**
     * The WalletVaultResponse
     * Meta information extracted from the WSDL
     * - choice: CardVaultResponse | WalletVaultResponse | LookUpVaultResponse | DeleteVaultResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\WalletVaultResponseType
     */
    public $WalletVaultResponse;
    /**
     * The LookUpVaultResponse
     * Meta information extracted from the WSDL
     * - choice: CardVaultResponse | WalletVaultResponse | LookUpVaultResponse | DeleteVaultResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\LookUpVaultResponseType
     */
    public $LookUpVaultResponse;
    /**
     * The DeleteVaultResponse
     * Meta information extracted from the WSDL
     * - choice: CardVaultResponse | WalletVaultResponse | LookUpVaultResponse | DeleteVaultResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\DeleteVaultResponseType
     */
    public $DeleteVaultResponse;
    /**
     * Constructor method for SingleVaultResponse
     * @uses SingleVaultResponse::setCardVaultResponse()
     * @uses SingleVaultResponse::setWalletVaultResponse()
     * @uses SingleVaultResponse::setLookUpVaultResponse()
     * @uses SingleVaultResponse::setDeleteVaultResponse()
     * @param \StructType\CardVaultResponseType $cardVaultResponse
     * @param \StructType\WalletVaultResponseType $walletVaultResponse
     * @param \StructType\LookUpVaultResponseType $lookUpVaultResponse
     * @param \StructType\DeleteVaultResponseType $deleteVaultResponse
     */
    public function __construct(\StructType\CardVaultResponseType $cardVaultResponse = null, \StructType\WalletVaultResponseType $walletVaultResponse = null, \StructType\LookUpVaultResponseType $lookUpVaultResponse = null, \StructType\DeleteVaultResponseType $deleteVaultResponse = null)
    {
        $this
            ->setCardVaultResponse($cardVaultResponse)
            ->setWalletVaultResponse($walletVaultResponse)
            ->setLookUpVaultResponse($lookUpVaultResponse)
            ->setDeleteVaultResponse($deleteVaultResponse);
    }
    /**
     * Get CardVaultResponse value
     * @return \StructType\CardVaultResponseType|null
     */
    public function getCardVaultResponse()
    {
        return isset($this->CardVaultResponse) ? $this->CardVaultResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCardVaultResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardVaultResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCardVaultResponseForChoiceConstraintsFromSetCardVaultResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'WalletVaultResponse',
            'LookUpVaultResponse',
            'DeleteVaultResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CardVaultResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: CardVaultResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CardVaultResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CardVaultResponseType $cardVaultResponse
     * @return \StructType\SingleVaultResponse
     */
    public function setCardVaultResponse(\StructType\CardVaultResponseType $cardVaultResponse = null)
    {
        // validation for constraint: choice(CardVaultResponse, WalletVaultResponse, LookUpVaultResponse, DeleteVaultResponse)
        if ('' !== ($cardVaultResponseChoiceErrorMessage = self::validateCardVaultResponseForChoiceConstraintsFromSetCardVaultResponse($cardVaultResponse))) {
            throw new \InvalidArgumentException($cardVaultResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($cardVaultResponse) || (is_array($cardVaultResponse) && empty($cardVaultResponse))) {
            unset($this->CardVaultResponse);
        } else {
            $this->CardVaultResponse = $cardVaultResponse;
        }
        return $this;
    }
    /**
     * Get WalletVaultResponse value
     * @return \StructType\WalletVaultResponseType|null
     */
    public function getWalletVaultResponse()
    {
        return isset($this->WalletVaultResponse) ? $this->WalletVaultResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWalletVaultResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWalletVaultResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWalletVaultResponseForChoiceConstraintsFromSetWalletVaultResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultResponse',
            'LookUpVaultResponse',
            'DeleteVaultResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property WalletVaultResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: WalletVaultResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set WalletVaultResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WalletVaultResponseType $walletVaultResponse
     * @return \StructType\SingleVaultResponse
     */
    public function setWalletVaultResponse(\StructType\WalletVaultResponseType $walletVaultResponse = null)
    {
        // validation for constraint: choice(CardVaultResponse, WalletVaultResponse, LookUpVaultResponse, DeleteVaultResponse)
        if ('' !== ($walletVaultResponseChoiceErrorMessage = self::validateWalletVaultResponseForChoiceConstraintsFromSetWalletVaultResponse($walletVaultResponse))) {
            throw new \InvalidArgumentException($walletVaultResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($walletVaultResponse) || (is_array($walletVaultResponse) && empty($walletVaultResponse))) {
            unset($this->WalletVaultResponse);
        } else {
            $this->WalletVaultResponse = $walletVaultResponse;
        }
        return $this;
    }
    /**
     * Get LookUpVaultResponse value
     * @return \StructType\LookUpVaultResponseType|null
     */
    public function getLookUpVaultResponse()
    {
        return isset($this->LookUpVaultResponse) ? $this->LookUpVaultResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLookUpVaultResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLookUpVaultResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLookUpVaultResponseForChoiceConstraintsFromSetLookUpVaultResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultResponse',
            'WalletVaultResponse',
            'DeleteVaultResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property LookUpVaultResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: LookUpVaultResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set LookUpVaultResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LookUpVaultResponseType $lookUpVaultResponse
     * @return \StructType\SingleVaultResponse
     */
    public function setLookUpVaultResponse(\StructType\LookUpVaultResponseType $lookUpVaultResponse = null)
    {
        // validation for constraint: choice(CardVaultResponse, WalletVaultResponse, LookUpVaultResponse, DeleteVaultResponse)
        if ('' !== ($lookUpVaultResponseChoiceErrorMessage = self::validateLookUpVaultResponseForChoiceConstraintsFromSetLookUpVaultResponse($lookUpVaultResponse))) {
            throw new \InvalidArgumentException($lookUpVaultResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($lookUpVaultResponse) || (is_array($lookUpVaultResponse) && empty($lookUpVaultResponse))) {
            unset($this->LookUpVaultResponse);
        } else {
            $this->LookUpVaultResponse = $lookUpVaultResponse;
        }
        return $this;
    }
    /**
     * Get DeleteVaultResponse value
     * @return \StructType\DeleteVaultResponseType|null
     */
    public function getDeleteVaultResponse()
    {
        return isset($this->DeleteVaultResponse) ? $this->DeleteVaultResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDeleteVaultResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeleteVaultResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDeleteVaultResponseForChoiceConstraintsFromSetDeleteVaultResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CardVaultResponse',
            'WalletVaultResponse',
            'LookUpVaultResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DeleteVaultResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: DeleteVaultResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DeleteVaultResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeleteVaultResponseType $deleteVaultResponse
     * @return \StructType\SingleVaultResponse
     */
    public function setDeleteVaultResponse(\StructType\DeleteVaultResponseType $deleteVaultResponse = null)
    {
        // validation for constraint: choice(CardVaultResponse, WalletVaultResponse, LookUpVaultResponse, DeleteVaultResponse)
        if ('' !== ($deleteVaultResponseChoiceErrorMessage = self::validateDeleteVaultResponseForChoiceConstraintsFromSetDeleteVaultResponse($deleteVaultResponse))) {
            throw new \InvalidArgumentException($deleteVaultResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($deleteVaultResponse) || (is_array($deleteVaultResponse) && empty($deleteVaultResponse))) {
            unset($this->DeleteVaultResponse);
        } else {
            $this->DeleteVaultResponse = $deleteVaultResponse;
        }
        return $this;
    }
}
