<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SingleFollowUpResponse StructType
 * @subpackage Structs
 */
class SingleFollowUpResponse extends AbstractStructBase
{
    /**
     * The QueryResponse
     * Meta information extracted from the WSDL
     * - choice: QueryResponse | SettlementResponse | RefundResponse | VoidResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\QueryResponseType[]
     */
    public $QueryResponse;
    /**
     * The SettlementResponse
     * Meta information extracted from the WSDL
     * - choice: QueryResponse | SettlementResponse | RefundResponse | VoidResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SettleResponseType
     */
    public $SettlementResponse;
    /**
     * The RefundResponse
     * Meta information extracted from the WSDL
     * - choice: QueryResponse | SettlementResponse | RefundResponse | VoidResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\RefundResponseType
     */
    public $RefundResponse;
    /**
     * The VoidResponse
     * Meta information extracted from the WSDL
     * - choice: QueryResponse | SettlementResponse | RefundResponse | VoidResponse
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\VoidResponseType
     */
    public $VoidResponse;
    /**
     * Constructor method for SingleFollowUpResponse
     * @uses SingleFollowUpResponse::setQueryResponse()
     * @uses SingleFollowUpResponse::setSettlementResponse()
     * @uses SingleFollowUpResponse::setRefundResponse()
     * @uses SingleFollowUpResponse::setVoidResponse()
     * @param \StructType\QueryResponseType[] $queryResponse
     * @param \StructType\SettleResponseType $settlementResponse
     * @param \StructType\RefundResponseType $refundResponse
     * @param \StructType\VoidResponseType $voidResponse
     */
    public function __construct(array $queryResponse = array(), \StructType\SettleResponseType $settlementResponse = null, \StructType\RefundResponseType $refundResponse = null, \StructType\VoidResponseType $voidResponse = null)
    {
        $this
            ->setQueryResponse($queryResponse)
            ->setSettlementResponse($settlementResponse)
            ->setRefundResponse($refundResponse)
            ->setVoidResponse($voidResponse);
    }
    /**
     * Get QueryResponse value
     * @return \StructType\QueryResponseType[]
     */
    public function getQueryResponse()
    {
        return isset($this->QueryResponse) ? $this->QueryResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQueryResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQueryResponseForArrayConstraintsFromSetQueryResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $singleFollowUpResponseQueryResponseItem) {
            // validation for constraint: itemType
            if (!$singleFollowUpResponseQueryResponseItem instanceof \StructType\QueryResponseType) {
                $invalidValues[] = is_object($singleFollowUpResponseQueryResponseItem) ? get_class($singleFollowUpResponseQueryResponseItem) : sprintf('%s(%s)', gettype($singleFollowUpResponseQueryResponseItem), var_export($singleFollowUpResponseQueryResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The QueryResponse property can only contain items of type \StructType\QueryResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setQueryResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQueryResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateQueryResponseForChoiceConstraintsFromSetQueryResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SettlementResponse',
            'RefundResponse',
            'VoidResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property QueryResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: QueryResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set QueryResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\QueryResponseType[] $queryResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setQueryResponse(array $queryResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($queryResponseArrayErrorMessage = self::validateQueryResponseForArrayConstraintsFromSetQueryResponse($queryResponse))) {
            throw new \InvalidArgumentException($queryResponseArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(QueryResponse, SettlementResponse, RefundResponse, VoidResponse)
        if ('' !== ($queryResponseChoiceErrorMessage = self::validateQueryResponseForChoiceConstraintsFromSetQueryResponse($queryResponse))) {
            throw new \InvalidArgumentException($queryResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($queryResponse) || (is_array($queryResponse) && empty($queryResponse))) {
            unset($this->QueryResponse);
        } else {
            $this->QueryResponse = $queryResponse;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToQueryResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToQueryResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToQueryResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SettlementResponse',
            'RefundResponse',
            'VoidResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property QueryResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: QueryResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to QueryResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\QueryResponseType $item
     * @return \StructType\SingleFollowUpResponse
     */
    public function addToQueryResponse(\StructType\QueryResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\QueryResponseType) {
            throw new \InvalidArgumentException(sprintf('The QueryResponse property can only contain items of type \StructType\QueryResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(QueryResponse, SettlementResponse, RefundResponse, VoidResponse)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToQueryResponse($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->QueryResponse[] = $item;
        return $this;
    }
    /**
     * Get SettlementResponse value
     * @return \StructType\SettleResponseType|null
     */
    public function getSettlementResponse()
    {
        return isset($this->SettlementResponse) ? $this->SettlementResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSettlementResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlementResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSettlementResponseForChoiceConstraintsFromSetSettlementResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryResponse',
            'RefundResponse',
            'VoidResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SettlementResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: SettlementResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SettlementResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettleResponseType $settlementResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setSettlementResponse(\StructType\SettleResponseType $settlementResponse = null)
    {
        // validation for constraint: choice(QueryResponse, SettlementResponse, RefundResponse, VoidResponse)
        if ('' !== ($settlementResponseChoiceErrorMessage = self::validateSettlementResponseForChoiceConstraintsFromSetSettlementResponse($settlementResponse))) {
            throw new \InvalidArgumentException($settlementResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($settlementResponse) || (is_array($settlementResponse) && empty($settlementResponse))) {
            unset($this->SettlementResponse);
        } else {
            $this->SettlementResponse = $settlementResponse;
        }
        return $this;
    }
    /**
     * Get RefundResponse value
     * @return \StructType\RefundResponseType|null
     */
    public function getRefundResponse()
    {
        return isset($this->RefundResponse) ? $this->RefundResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRefundResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefundResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRefundResponseForChoiceConstraintsFromSetRefundResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryResponse',
            'SettlementResponse',
            'VoidResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RefundResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: RefundResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RefundResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RefundResponseType $refundResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setRefundResponse(\StructType\RefundResponseType $refundResponse = null)
    {
        // validation for constraint: choice(QueryResponse, SettlementResponse, RefundResponse, VoidResponse)
        if ('' !== ($refundResponseChoiceErrorMessage = self::validateRefundResponseForChoiceConstraintsFromSetRefundResponse($refundResponse))) {
            throw new \InvalidArgumentException($refundResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($refundResponse) || (is_array($refundResponse) && empty($refundResponse))) {
            unset($this->RefundResponse);
        } else {
            $this->RefundResponse = $refundResponse;
        }
        return $this;
    }
    /**
     * Get VoidResponse value
     * @return \StructType\VoidResponseType|null
     */
    public function getVoidResponse()
    {
        return isset($this->VoidResponse) ? $this->VoidResponse : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVoidResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoidResponse method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVoidResponseForChoiceConstraintsFromSetVoidResponse($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'QueryResponse',
            'SettlementResponse',
            'RefundResponse',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VoidResponse can\'t be set as the property %s is already set. Only one property must be set among these properties: VoidResponse, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VoidResponse value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VoidResponseType $voidResponse
     * @return \StructType\SingleFollowUpResponse
     */
    public function setVoidResponse(\StructType\VoidResponseType $voidResponse = null)
    {
        // validation for constraint: choice(QueryResponse, SettlementResponse, RefundResponse, VoidResponse)
        if ('' !== ($voidResponseChoiceErrorMessage = self::validateVoidResponseForChoiceConstraintsFromSetVoidResponse($voidResponse))) {
            throw new \InvalidArgumentException($voidResponseChoiceErrorMessage, __LINE__);
        }
        if (is_null($voidResponse) || (is_array($voidResponse) && empty($voidResponse))) {
            unset($this->VoidResponse);
        } else {
            $this->VoidResponse = $voidResponse;
        }
        return $this;
    }
}
