<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The AddressLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AddressLine;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setAddressLine()
     * @uses AddressType::setCity()
     * @uses AddressType::setCountry()
     * @uses AddressType::setState()
     * @uses AddressType::setZip()
     * @param string[] $addressLine
     * @param string $city
     * @param string $country
     * @param string $state
     * @param string $zip
     */
    public function __construct(array $addressLine = array(), $city = null, $country = null, $state = null, $zip = null)
    {
        $this
            ->setAddressLine($addressLine)
            ->setCity($city)
            ->setCountry($country)
            ->setState($state)
            ->setZip($zip);
    }
    /**
     * Get AddressLine value
     * @return string[]|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressLineForArrayConstraintsFromSetAddressLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addressTypeAddressLineItem) {
            // validation for constraint: itemType
            if (!is_string($addressTypeAddressLineItem)) {
                $invalidValues[] = is_object($addressTypeAddressLineItem) ? get_class($addressTypeAddressLineItem) : sprintf('%s(%s)', gettype($addressTypeAddressLineItem), var_export($addressTypeAddressLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressLine property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressLine value
     * @throws \InvalidArgumentException
     * @param string[] $addressLine
     * @return \StructType\AddressType
     */
    public function setAddressLine(array $addressLine = array())
    {
        // validation for constraint: array
        if ('' !== ($addressLineArrayErrorMessage = self::validateAddressLineForArrayConstraintsFromSetAddressLine($addressLine))) {
            throw new \InvalidArgumentException($addressLineArrayErrorMessage, __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Add item to AddressLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AddressType
     */
    public function addToAddressLine($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The AddressLine property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressLine[] = $item;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryType::valueIsValid()
     * @uses \EnumType\CountryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\AddressType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CountryType', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\CountryType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\AddressType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \StructType\AddressType
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
}
