<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.paygate.co.za/payhost/process.trans?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://secure.paygate.co.za/payhost/process.trans?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \StructType\PingRequest()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Single ServiceType
 */
$single = new \ServiceType\Single($options);
/**
 * Sample call for SinglePayout operation/method
 */
if ($single->SinglePayout(new \StructType\SinglePayoutRequest()) !== false) {
    print_r($single->getResult());
} else {
    print_r($single->getLastError());
}
/**
 * Sample call for SinglePayment operation/method
 */
if ($single->SinglePayment(new \StructType\SinglePaymentRequest()) !== false) {
    print_r($single->getResult());
} else {
    print_r($single->getLastError());
}
/**
 * Sample call for SingleFollowUp operation/method
 */
if ($single->SingleFollowUp(new \StructType\SingleFollowUpRequest()) !== false) {
    print_r($single->getResult());
} else {
    print_r($single->getLastError());
}
/**
 * Sample call for SingleVault operation/method
 */
if ($single->SingleVault(new \StructType\SingleVaultRequest()) !== false) {
    print_r($single->getResult());
} else {
    print_r($single->getLastError());
}
