<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebPaymentRequestType StructType
 * @subpackage Structs
 */
class WebPaymentRequestType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonType
     */
    public $Customer;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The Vault
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Vault;
    /**
     * The VaultId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VaultId;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentType[]
     */
    public $PaymentType;
    /**
     * The Redirect
     * @var \StructType\RedirectRequestType
     */
    public $Redirect;
    /**
     * The Order
     * @var \StructType\OrderType
     */
    public $Order;
    /**
     * The ThreeDSecure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ThreeDSecureType
     */
    public $ThreeDSecure;
    /**
     * The Risk
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RiskType
     */
    public $Risk;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * The BillingDescriptor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingDescriptor;
    /**
     * The Facilitator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FacilitatorType
     */
    public $Facilitator;
    /**
     * The Geolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $Geolocation;
    /**
     * The ServiceGeolocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeolocationType
     */
    public $ServiceGeolocation;
    /**
     * The Recurring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecurringType
     */
    public $Recurring;
    /**
     * Constructor method for WebPaymentRequestType
     * @uses WebPaymentRequestType::setCustomer()
     * @uses WebPaymentRequestType::setAccount()
     * @uses WebPaymentRequestType::setVault()
     * @uses WebPaymentRequestType::setVaultId()
     * @uses WebPaymentRequestType::setPaymentType()
     * @uses WebPaymentRequestType::setRedirect()
     * @uses WebPaymentRequestType::setOrder()
     * @uses WebPaymentRequestType::setThreeDSecure()
     * @uses WebPaymentRequestType::setRisk()
     * @uses WebPaymentRequestType::setUserDefinedFields()
     * @uses WebPaymentRequestType::setBillingDescriptor()
     * @uses WebPaymentRequestType::setFacilitator()
     * @uses WebPaymentRequestType::setGeolocation()
     * @uses WebPaymentRequestType::setServiceGeolocation()
     * @uses WebPaymentRequestType::setRecurring()
     * @param \StructType\PersonType $customer
     * @param \StructType\PayGateAccountType $account
     * @param bool $vault
     * @param string $vaultId
     * @param \StructType\PaymentType[] $paymentType
     * @param \StructType\RedirectRequestType $redirect
     * @param \StructType\OrderType $order
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @param \StructType\RiskType $risk
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @param string $billingDescriptor
     * @param \StructType\FacilitatorType $facilitator
     * @param \StructType\GeolocationType $geolocation
     * @param \StructType\GeolocationType $serviceGeolocation
     * @param \StructType\RecurringType $recurring
     */
    public function __construct(\StructType\PersonType $customer = null, \StructType\PayGateAccountType $account = null, $vault = false, $vaultId = null, array $paymentType = array(), \StructType\RedirectRequestType $redirect = null, \StructType\OrderType $order = null, \StructType\ThreeDSecureType $threeDSecure = null, \StructType\RiskType $risk = null, array $userDefinedFields = array(), $billingDescriptor = null, \StructType\FacilitatorType $facilitator = null, \StructType\GeolocationType $geolocation = null, \StructType\GeolocationType $serviceGeolocation = null, \StructType\RecurringType $recurring = null)
    {
        $this
            ->setCustomer($customer)
            ->setAccount($account)
            ->setVault($vault)
            ->setVaultId($vaultId)
            ->setPaymentType($paymentType)
            ->setRedirect($redirect)
            ->setOrder($order)
            ->setThreeDSecure($threeDSecure)
            ->setRisk($risk)
            ->setUserDefinedFields($userDefinedFields)
            ->setBillingDescriptor($billingDescriptor)
            ->setFacilitator($facilitator)
            ->setGeolocation($geolocation)
            ->setServiceGeolocation($serviceGeolocation)
            ->setRecurring($recurring);
    }
    /**
     * Get Customer value
     * @return \StructType\PersonType
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\PersonType $customer
     * @return \StructType\WebPaymentRequestType
     */
    public function setCustomer(\StructType\PersonType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\WebPaymentRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Vault value
     * @return bool|null
     */
    public function getVault()
    {
        return $this->Vault;
    }
    /**
     * Set Vault value
     * @param bool $vault
     * @return \StructType\WebPaymentRequestType
     */
    public function setVault($vault = false)
    {
        // validation for constraint: boolean
        if (!is_null($vault) && !is_bool($vault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vault, true), gettype($vault)), __LINE__);
        }
        $this->Vault = $vault;
        return $this;
    }
    /**
     * Get VaultId value
     * @return string|null
     */
    public function getVaultId()
    {
        return $this->VaultId;
    }
    /**
     * Set VaultId value
     * @param string $vaultId
     * @return \StructType\WebPaymentRequestType
     */
    public function setVaultId($vaultId = null)
    {
        // validation for constraint: string
        if (!is_null($vaultId) && !is_string($vaultId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vaultId, true), gettype($vaultId)), __LINE__);
        }
        $this->VaultId = $vaultId;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return \StructType\PaymentType[]|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTypeForArrayConstraintsFromSetPaymentType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webPaymentRequestTypePaymentTypeItem) {
            // validation for constraint: itemType
            if (!$webPaymentRequestTypePaymentTypeItem instanceof \StructType\PaymentType) {
                $invalidValues[] = is_object($webPaymentRequestTypePaymentTypeItem) ? get_class($webPaymentRequestTypePaymentTypeItem) : sprintf('%s(%s)', gettype($webPaymentRequestTypePaymentTypeItem), var_export($webPaymentRequestTypePaymentTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentType property can only contain items of type \StructType\PaymentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentType value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType[] $paymentType
     * @return \StructType\WebPaymentRequestType
     */
    public function setPaymentType(array $paymentType = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTypeArrayErrorMessage = self::validatePaymentTypeForArrayConstraintsFromSetPaymentType($paymentType))) {
            throw new \InvalidArgumentException($paymentTypeArrayErrorMessage, __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Add item to PaymentType value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType $item
     * @return \StructType\WebPaymentRequestType
     */
    public function addToPaymentType(\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of type \StructType\PaymentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentType[] = $item;
        return $this;
    }
    /**
     * Get Redirect value
     * @return \StructType\RedirectRequestType|null
     */
    public function getRedirect()
    {
        return $this->Redirect;
    }
    /**
     * Set Redirect value
     * @param \StructType\RedirectRequestType $redirect
     * @return \StructType\WebPaymentRequestType
     */
    public function setRedirect(\StructType\RedirectRequestType $redirect = null)
    {
        $this->Redirect = $redirect;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderType|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderType $order
     * @return \StructType\WebPaymentRequestType
     */
    public function setOrder(\StructType\OrderType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ThreeDSecure value
     * @return \StructType\ThreeDSecureType|null
     */
    public function getThreeDSecure()
    {
        return $this->ThreeDSecure;
    }
    /**
     * Set ThreeDSecure value
     * @param \StructType\ThreeDSecureType $threeDSecure
     * @return \StructType\WebPaymentRequestType
     */
    public function setThreeDSecure(\StructType\ThreeDSecureType $threeDSecure = null)
    {
        $this->ThreeDSecure = $threeDSecure;
        return $this;
    }
    /**
     * Get Risk value
     * @return \StructType\RiskType|null
     */
    public function getRisk()
    {
        return $this->Risk;
    }
    /**
     * Set Risk value
     * @param \StructType\RiskType $risk
     * @return \StructType\WebPaymentRequestType
     */
    public function setRisk(\StructType\RiskType $risk = null)
    {
        $this->Risk = $risk;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webPaymentRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$webPaymentRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($webPaymentRequestTypeUserDefinedFieldsItem) ? get_class($webPaymentRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($webPaymentRequestTypeUserDefinedFieldsItem), var_export($webPaymentRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\WebPaymentRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\WebPaymentRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
    /**
     * Get BillingDescriptor value
     * @return string|null
     */
    public function getBillingDescriptor()
    {
        return $this->BillingDescriptor;
    }
    /**
     * Set BillingDescriptor value
     * @param string $billingDescriptor
     * @return \StructType\WebPaymentRequestType
     */
    public function setBillingDescriptor($billingDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($billingDescriptor) && !is_string($billingDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDescriptor, true), gettype($billingDescriptor)), __LINE__);
        }
        $this->BillingDescriptor = $billingDescriptor;
        return $this;
    }
    /**
     * Get Facilitator value
     * @return \StructType\FacilitatorType|null
     */
    public function getFacilitator()
    {
        return $this->Facilitator;
    }
    /**
     * Set Facilitator value
     * @param \StructType\FacilitatorType $facilitator
     * @return \StructType\WebPaymentRequestType
     */
    public function setFacilitator(\StructType\FacilitatorType $facilitator = null)
    {
        $this->Facilitator = $facilitator;
        return $this;
    }
    /**
     * Get Geolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getGeolocation()
    {
        return $this->Geolocation;
    }
    /**
     * Set Geolocation value
     * @param \StructType\GeolocationType $geolocation
     * @return \StructType\WebPaymentRequestType
     */
    public function setGeolocation(\StructType\GeolocationType $geolocation = null)
    {
        $this->Geolocation = $geolocation;
        return $this;
    }
    /**
     * Get ServiceGeolocation value
     * @return \StructType\GeolocationType|null
     */
    public function getServiceGeolocation()
    {
        return $this->ServiceGeolocation;
    }
    /**
     * Set ServiceGeolocation value
     * @param \StructType\GeolocationType $serviceGeolocation
     * @return \StructType\WebPaymentRequestType
     */
    public function setServiceGeolocation(\StructType\GeolocationType $serviceGeolocation = null)
    {
        $this->ServiceGeolocation = $serviceGeolocation;
        return $this;
    }
    /**
     * Get Recurring value
     * @return \StructType\RecurringType|null
     */
    public function getRecurring()
    {
        return $this->Recurring;
    }
    /**
     * Set Recurring value
     * @param \StructType\RecurringType $recurring
     * @return \StructType\WebPaymentRequestType
     */
    public function setRecurring(\StructType\RecurringType $recurring = null)
    {
        $this->Recurring = $recurring;
        return $this;
    }
}
