<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WalletVaultRequestType StructType
 * @subpackage Structs
 */
class WalletVaultRequestType extends AbstractStructBase
{
    /**
     * The WalletAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WalletAccount;
    /**
     * The Account
     * @var \StructType\PayGateAccountType
     */
    public $Account;
    /**
     * The WalletPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WalletPassword;
    /**
     * The UserDefinedFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValueType[]
     */
    public $UserDefinedFields;
    /**
     * Constructor method for WalletVaultRequestType
     * @uses WalletVaultRequestType::setWalletAccount()
     * @uses WalletVaultRequestType::setAccount()
     * @uses WalletVaultRequestType::setWalletPassword()
     * @uses WalletVaultRequestType::setUserDefinedFields()
     * @param string $walletAccount
     * @param \StructType\PayGateAccountType $account
     * @param string $walletPassword
     * @param \StructType\KeyValueType[] $userDefinedFields
     */
    public function __construct($walletAccount = null, \StructType\PayGateAccountType $account = null, $walletPassword = null, array $userDefinedFields = array())
    {
        $this
            ->setWalletAccount($walletAccount)
            ->setAccount($account)
            ->setWalletPassword($walletPassword)
            ->setUserDefinedFields($userDefinedFields);
    }
    /**
     * Get WalletAccount value
     * @return string
     */
    public function getWalletAccount()
    {
        return $this->WalletAccount;
    }
    /**
     * Set WalletAccount value
     * @param string $walletAccount
     * @return \StructType\WalletVaultRequestType
     */
    public function setWalletAccount($walletAccount = null)
    {
        // validation for constraint: string
        if (!is_null($walletAccount) && !is_string($walletAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletAccount, true), gettype($walletAccount)), __LINE__);
        }
        $this->WalletAccount = $walletAccount;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\PayGateAccountType|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\PayGateAccountType $account
     * @return \StructType\WalletVaultRequestType
     */
    public function setAccount(\StructType\PayGateAccountType $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get WalletPassword value
     * @return string|null
     */
    public function getWalletPassword()
    {
        return $this->WalletPassword;
    }
    /**
     * Set WalletPassword value
     * @param string $walletPassword
     * @return \StructType\WalletVaultRequestType
     */
    public function setWalletPassword($walletPassword = null)
    {
        // validation for constraint: string
        if (!is_null($walletPassword) && !is_string($walletPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($walletPassword, true), gettype($walletPassword)), __LINE__);
        }
        $this->WalletPassword = $walletPassword;
        return $this;
    }
    /**
     * Get UserDefinedFields value
     * @return \StructType\KeyValueType[]|null
     */
    public function getUserDefinedFields()
    {
        return $this->UserDefinedFields;
    }
    /**
     * This method is responsible for validating the values passed to the setUserDefinedFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserDefinedFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $walletVaultRequestTypeUserDefinedFieldsItem) {
            // validation for constraint: itemType
            if (!$walletVaultRequestTypeUserDefinedFieldsItem instanceof \StructType\KeyValueType) {
                $invalidValues[] = is_object($walletVaultRequestTypeUserDefinedFieldsItem) ? get_class($walletVaultRequestTypeUserDefinedFieldsItem) : sprintf('%s(%s)', gettype($walletVaultRequestTypeUserDefinedFieldsItem), var_export($walletVaultRequestTypeUserDefinedFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType[] $userDefinedFields
     * @return \StructType\WalletVaultRequestType
     */
    public function setUserDefinedFields(array $userDefinedFields = array())
    {
        // validation for constraint: array
        if ('' !== ($userDefinedFieldsArrayErrorMessage = self::validateUserDefinedFieldsForArrayConstraintsFromSetUserDefinedFields($userDefinedFields))) {
            throw new \InvalidArgumentException($userDefinedFieldsArrayErrorMessage, __LINE__);
        }
        $this->UserDefinedFields = $userDefinedFields;
        return $this;
    }
    /**
     * Add item to UserDefinedFields value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValueType $item
     * @return \StructType\WalletVaultRequestType
     */
    public function addToUserDefinedFields(\StructType\KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValueType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedFields property can only contain items of type \StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserDefinedFields[] = $item;
        return $this;
    }
}
