<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnstructuredFareCalc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the fare calc information for the stored fare for the passenger. This field should not exceed 87 characters, | Used for Character Strings, length 1 to 128
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class UnstructuredFareCalc extends AbstractStructBase
{
    /**
     * The FareCalcMode
     * Meta informations extracted from the WSDL
     * - documentation: Used to identify the method of pricing for this transaction (e.g., manual, automated pricing). Should be 1 character in length.
     * - use: optional
     * @var string
     */
    public $FareCalcMode;
    /**
     * Constructor method for UnstructuredFareCalc
     * @uses UnstructuredFareCalc::setFareCalcMode()
     * @param string $fareCalcMode
     */
    public function __construct($fareCalcMode = null)
    {
        $this
            ->setFareCalcMode($fareCalcMode);
    }
    /**
     * Get FareCalcMode value
     * @return string|null
     */
    public function getFareCalcMode()
    {
        return $this->FareCalcMode;
    }
    /**
     * Set FareCalcMode value
     * @param string $fareCalcMode
     * @return \StructType\UnstructuredFareCalc
     */
    public function setFareCalcMode($fareCalcMode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalcMode) && !is_string($fareCalcMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareCalcMode)), __LINE__);
        }
        $this->FareCalcMode = $fareCalcMode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnstructuredFareCalc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
