<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold the seat details that is to be requested.
 * @subpackage Structs
 */
class SeatDetails extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The ResBookDesignations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResBookDesignations
     */
    public $ResBookDesignations;
    /**
     * The SeatUpgrade
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: SeatUpgrade will be set to true if the passenger is looking for an upgrade and the seat map response expected is after the upgrade, if applicable
     * - use: optional
     * @var bool
     */
    public $SeatUpgrade;
    /**
     * Constructor method for SeatDetails
     * @uses SeatDetails::setCabinClass()
     * @uses SeatDetails::setResBookDesignations()
     * @uses SeatDetails::setSeatUpgrade()
     * @param \StructType\CabinClass[] $cabinClass
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @param bool $seatUpgrade
     */
    public function __construct(array $cabinClass = array(), \StructType\ResBookDesignations $resBookDesignations = null, $seatUpgrade = false)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setResBookDesignations($resBookDesignations)
            ->setSeatUpgrade($seatUpgrade);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\SeatDetails
     */
    public function setCabinClass(array $cabinClass = array())
    {
        foreach ($cabinClass as $seatDetailsCabinClassItem) {
            // validation for constraint: itemType
            if (!$seatDetailsCabinClassItem instanceof \StructType\CabinClass) {
                throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($seatDetailsCabinClassItem) ? get_class($seatDetailsCabinClassItem) : gettype($seatDetailsCabinClassItem)), __LINE__);
            }
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\SeatDetails
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesignations value
     * @return \StructType\ResBookDesignations|null
     */
    public function getResBookDesignations()
    {
        return $this->ResBookDesignations;
    }
    /**
     * Set ResBookDesignations value
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @return \StructType\SeatDetails
     */
    public function setResBookDesignations(\StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this->ResBookDesignations = $resBookDesignations;
        return $this;
    }
    /**
     * Get SeatUpgrade value
     * @return bool|null
     */
    public function getSeatUpgrade()
    {
        return $this->SeatUpgrade;
    }
    /**
     * Set SeatUpgrade value
     * @param bool $seatUpgrade
     * @return \StructType\SeatDetails
     */
    public function setSeatUpgrade($seatUpgrade = false)
    {
        // validation for constraint: boolean
        if (!is_null($seatUpgrade) && !is_bool($seatUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($seatUpgrade)), __LINE__);
        }
        $this->SeatUpgrade = $seatUpgrade;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
