<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchTravelerType StructType
 * @subpackage Structs
 */
class SearchTravelerType extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CitizenCountryName
     */
    public $CitizenCountryName;
    /**
     * The IndCoverageReqs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $IndCoverageReqs;
    /**
     * The Age
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Age;
    /**
     * The Relation
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Relation;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Gender;
    /**
     * Constructor method for SearchTravelerType
     * @uses SearchTravelerType::setAddress()
     * @uses SearchTravelerType::setCitizenCountryName()
     * @uses SearchTravelerType::setIndCoverageReqs()
     * @uses SearchTravelerType::setAge()
     * @uses SearchTravelerType::setRelation()
     * @uses SearchTravelerType::setGender()
     * @param mixed $address
     * @param \StructType\CitizenCountryName $citizenCountryName
     * @param mixed $indCoverageReqs
     * @param int $age
     * @param string $relation
     * @param string $gender
     */
    public function __construct($address = null, \StructType\CitizenCountryName $citizenCountryName = null, $indCoverageReqs = null, $age = null, $relation = null, $gender = null)
    {
        $this
            ->setAddress($address)
            ->setCitizenCountryName($citizenCountryName)
            ->setIndCoverageReqs($indCoverageReqs)
            ->setAge($age)
            ->setRelation($relation)
            ->setGender($gender);
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\SearchTravelerType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \StructType\CitizenCountryName|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @param \StructType\CitizenCountryName $citizenCountryName
     * @return \StructType\SearchTravelerType
     */
    public function setCitizenCountryName(\StructType\CitizenCountryName $citizenCountryName = null)
    {
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Get IndCoverageReqs value
     * @return mixed|null
     */
    public function getIndCoverageReqs()
    {
        return $this->IndCoverageReqs;
    }
    /**
     * Set IndCoverageReqs value
     * @param mixed $indCoverageReqs
     * @return \StructType\SearchTravelerType
     */
    public function setIndCoverageReqs($indCoverageReqs = null)
    {
        $this->IndCoverageReqs = $indCoverageReqs;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\SearchTravelerType
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Relation value
     * @return string|null
     */
    public function getRelation()
    {
        return $this->Relation;
    }
    /**
     * Set Relation value
     * @param string $relation
     * @return \StructType\SearchTravelerType
     */
    public function setRelation($relation = null)
    {
        // validation for constraint: string
        if (!is_null($relation) && !is_string($relation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relation)), __LINE__);
        }
        $this->Relation = $relation;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \StructType\SearchTravelerType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchTravelerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
