<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSRDetailsResponses StructType
 * Meta informations extracted from the WSDL
 * - documentation: ssr details response element containing the results of the request
 * @subpackage Structs
 */
class SSRDetailsResponses extends AbstractStructBase
{
    /**
     * The SSRDetailsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\SSRDetailsResponse[]
     */
    public $SSRDetailsResponse;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirTravelers
     */
    public $AirTravelers;
    /**
     * Constructor method for SSRDetailsResponses
     * @uses SSRDetailsResponses::setSSRDetailsResponse()
     * @uses SSRDetailsResponses::setAirTravelers()
     * @param \StructType\SSRDetailsResponse[] $sSRDetailsResponse
     * @param \StructType\AirTravelers $airTravelers
     */
    public function __construct(array $sSRDetailsResponse = array(), \StructType\AirTravelers $airTravelers = null)
    {
        $this
            ->setSSRDetailsResponse($sSRDetailsResponse)
            ->setAirTravelers($airTravelers);
    }
    /**
     * Get SSRDetailsResponse value
     * @return \StructType\SSRDetailsResponse[]|null
     */
    public function getSSRDetailsResponse()
    {
        return $this->SSRDetailsResponse;
    }
    /**
     * Set SSRDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SSRDetailsResponse[] $sSRDetailsResponse
     * @return \StructType\SSRDetailsResponses
     */
    public function setSSRDetailsResponse(array $sSRDetailsResponse = array())
    {
        foreach ($sSRDetailsResponse as $sSRDetailsResponsesSSRDetailsResponseItem) {
            // validation for constraint: itemType
            if (!$sSRDetailsResponsesSSRDetailsResponseItem instanceof \StructType\SSRDetailsResponse) {
                throw new \InvalidArgumentException(sprintf('The SSRDetailsResponse property can only contain items of \StructType\SSRDetailsResponse, "%s" given', is_object($sSRDetailsResponsesSSRDetailsResponseItem) ? get_class($sSRDetailsResponsesSSRDetailsResponseItem) : gettype($sSRDetailsResponsesSSRDetailsResponseItem)), __LINE__);
            }
        }
        $this->SSRDetailsResponse = $sSRDetailsResponse;
        return $this;
    }
    /**
     * Add item to SSRDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\SSRDetailsResponse $item
     * @return \StructType\SSRDetailsResponses
     */
    public function addToSSRDetailsResponse(\StructType\SSRDetailsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SSRDetailsResponse) {
            throw new \InvalidArgumentException(sprintf('The SSRDetailsResponse property can only contain items of \StructType\SSRDetailsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SSRDetailsResponse[] = $item;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \StructType\AirTravelers|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \StructType\AirTravelers $airTravelers
     * @return \StructType\SSRDetailsResponses
     */
    public function setAirTravelers(\StructType\AirTravelers $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSRDetailsResponses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
