<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSRDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold the ssr details that is to be requested.
 * @subpackage Structs
 */
class SSRDetails extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The ResBookDesignations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResBookDesignations
     */
    public $ResBookDesignations;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: Holds SSR type to differentiate In-flight services and airport services. Insert 'INFLIGHT' for in-flight services and 'AIRPORT' for airport services. If no value is provided system will consider it as an In-flight service.
     * - use: optional
     * @var string
     */
    public $ServiceType;
    /**
     * Constructor method for SSRDetails
     * @uses SSRDetails::setCabinClass()
     * @uses SSRDetails::setResBookDesignations()
     * @uses SSRDetails::setServiceType()
     * @param \StructType\CabinClass[] $cabinClass
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @param string $serviceType
     */
    public function __construct(array $cabinClass = array(), \StructType\ResBookDesignations $resBookDesignations = null, $serviceType = null)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setResBookDesignations($resBookDesignations)
            ->setServiceType($serviceType);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\SSRDetails
     */
    public function setCabinClass(array $cabinClass = array())
    {
        foreach ($cabinClass as $sSRDetailsCabinClassItem) {
            // validation for constraint: itemType
            if (!$sSRDetailsCabinClassItem instanceof \StructType\CabinClass) {
                throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($sSRDetailsCabinClassItem) ? get_class($sSRDetailsCabinClassItem) : gettype($sSRDetailsCabinClassItem)), __LINE__);
            }
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\SSRDetails
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of \StructType\CabinClass, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesignations value
     * @return \StructType\ResBookDesignations|null
     */
    public function getResBookDesignations()
    {
        return $this->ResBookDesignations;
    }
    /**
     * Set ResBookDesignations value
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @return \StructType\SSRDetails
     */
    public function setResBookDesignations(\StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this->ResBookDesignations = $resBookDesignations;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @uses \EnumType\SSRType::valueIsValid()
     * @uses \EnumType\SSRType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\SSRDetails
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SSRType::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\SSRType::getValidValues())), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSRDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
