<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationsList StructType
 * Meta informations extracted from the WSDL
 * - documentation: A container for multiple reservations. The list of reservations will be one of global reservations, air reservations, hotel reservations, package reservations, golf reservations, or vehicle reservations
 * @subpackage Structs
 */
class ReservationsList extends AbstractStructBase
{
    /**
     * The AirReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirReservation[]
     */
    public $AirReservation;
    /**
     * The GlobalReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GlobalReservation[]
     */
    public $GlobalReservation;
    /**
     * Constructor method for ReservationsList
     * @uses ReservationsList::setAirReservation()
     * @uses ReservationsList::setGlobalReservation()
     * @param \StructType\AirReservation[] $airReservation
     * @param \StructType\GlobalReservation[] $globalReservation
     */
    public function __construct(array $airReservation = array(), array $globalReservation = array())
    {
        $this
            ->setAirReservation($airReservation)
            ->setGlobalReservation($globalReservation);
    }
    /**
     * Get AirReservation value
     * @return \StructType\AirReservation[]|null
     */
    public function getAirReservation()
    {
        return $this->AirReservation;
    }
    /**
     * Set AirReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation[] $airReservation
     * @return \StructType\ReservationsList
     */
    public function setAirReservation(array $airReservation = array())
    {
        foreach ($airReservation as $reservationsListAirReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListAirReservationItem instanceof \StructType\AirReservation) {
                throw new \InvalidArgumentException(sprintf('The AirReservation property can only contain items of \StructType\AirReservation, "%s" given', is_object($reservationsListAirReservationItem) ? get_class($reservationsListAirReservationItem) : gettype($reservationsListAirReservationItem)), __LINE__);
            }
        }
        $this->AirReservation = $airReservation;
        return $this;
    }
    /**
     * Add item to AirReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToAirReservation(\StructType\AirReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirReservation) {
            throw new \InvalidArgumentException(sprintf('The AirReservation property can only contain items of \StructType\AirReservation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirReservation[] = $item;
        return $this;
    }
    /**
     * Get GlobalReservation value
     * @return \StructType\GlobalReservation[]|null
     */
    public function getGlobalReservation()
    {
        return $this->GlobalReservation;
    }
    /**
     * Set GlobalReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservation[] $globalReservation
     * @return \StructType\ReservationsList
     */
    public function setGlobalReservation(array $globalReservation = array())
    {
        foreach ($globalReservation as $reservationsListGlobalReservationItem) {
            // validation for constraint: itemType
            if (!$reservationsListGlobalReservationItem instanceof \StructType\GlobalReservation) {
                throw new \InvalidArgumentException(sprintf('The GlobalReservation property can only contain items of \StructType\GlobalReservation, "%s" given', is_object($reservationsListGlobalReservationItem) ? get_class($reservationsListGlobalReservationItem) : gettype($reservationsListGlobalReservationItem)), __LINE__);
            }
        }
        $this->GlobalReservation = $globalReservation;
        return $this;
    }
    /**
     * Add item to GlobalReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservation $item
     * @return \StructType\ReservationsList
     */
    public function addToGlobalReservation(\StructType\GlobalReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GlobalReservation) {
            throw new \InvalidArgumentException(sprintf('The GlobalReservation property can only contain items of \StructType\GlobalReservation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GlobalReservation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
