<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResBookDesignation StructType
 * Meta informations extracted from the WSDL
 * - documentation: If the seat map display is requested for the cabin class in which a particular booking designator code (booking class) lies then that booking class can be specified in this element. | If the meal details display is requested for the
 * cabin class in which a particular booking designator code (booking class) lies then that booking class can be specified in this element. | If the ssr details display is requested for the cabin class in which a particular booking designator code
 * (booking class) lies then that booking class can be specified in this element. | If the baggage details display is requested for the cabin class in which a particular booking designator code (booking class) lies then that booking class can be
 * specified in this element.
 * @subpackage Structs
 */
class ResBookDesignation extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - documentation: If the booking class is know for which the seat map is to be requested then the specific Booking class code can be entered here. The response will have the seat map for the cabin class in which the said booking classcode belongs. |
     * If the booking class is know for which the meal details are to be requested then the specific Booking class code can be entered here. The response will have the meal details for the cabin class in which the said booking classcode belongs. | If the
     * booking class is know for which the ssr details are to be requested then the specific Booking class code can be entered here. The response will have the ssr details for the cabin class in which the said booking classcode belongs. | If the booking
     * class is know for which the baggage details are to be requested then the specific Booking class code can be entered here. The response will have the baggage details for the cabin class in which the said booking classcode belongs. | Used for an Alpha
     * String, length 2 (for letter codes)
     * - use: optional
     * - pattern: [A-Z]{1,2}
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for ResBookDesignation
     * @uses ResBookDesignation::setResBookDesigCode()
     * @param string $resBookDesigCode
     */
    public function __construct($resBookDesigCode = null)
    {
        $this
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\ResBookDesignation
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z]{1,2}", "%s" given', var_export($resBookDesigCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResBookDesignation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
