<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestedCoveragesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Collection of insurance coverage requirements from the individuals requesting coverage.
 * @subpackage Structs
 */
class RequestedCoveragesType extends AbstractStructBase
{
    /**
     * The CoverageRequirement
     * Meta informations extracted from the WSDL
     * - documentation: Insurance coverage requirements shared by all travelers. | Insurance coverage requirements from the individuals requesting coverage.
     * - maxOccurs: 20
     * @var mixed[]
     */
    public $CoverageRequirement;
    /**
     * Constructor method for RequestedCoveragesType
     * @uses RequestedCoveragesType::setCoverageRequirement()
     * @param mixed[] $coverageRequirement
     */
    public function __construct(array $coverageRequirement = array())
    {
        $this
            ->setCoverageRequirement($coverageRequirement);
    }
    /**
     * Get CoverageRequirement value
     * @return mixed[]|null
     */
    public function getCoverageRequirement()
    {
        return $this->CoverageRequirement;
    }
    /**
     * Set CoverageRequirement value
     * @throws \InvalidArgumentException
     * @param mixed[] $coverageRequirement
     * @return \StructType\RequestedCoveragesType
     */
    public function setCoverageRequirement(array $coverageRequirement = array())
    {
        foreach ($coverageRequirement as $requestedCoveragesTypeCoverageRequirementItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The CoverageRequirement property can only contain items of anyType, "%s" given', is_object($requestedCoveragesTypeCoverageRequirementItem) ? get_class($requestedCoveragesTypeCoverageRequirementItem) : gettype($requestedCoveragesTypeCoverageRequirementItem)), __LINE__);
            }
        }
        $this->CoverageRequirement = $coverageRequirement;
        return $this;
    }
    /**
     * Add item to CoverageRequirement value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RequestedCoveragesType
     */
    public function addToCoverageRequirement($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The CoverageRequirement property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoverageRequirement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestedCoveragesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
