<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefPoint StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Reference Point element allows for a search by proximity to a designated reference point by name. | Used to specify a reference point by a code. | Used for Character Strings, length 1 to 64
 * - maxLength: 64
 * - minLength: 1
 * @subpackage Structs
 */
class RefPoint extends AbstractStructBase
{
    /**
     * The StateProv
     * Meta informations extracted from the WSDL
     * - documentation: The state or province in which the reference point is located.
     * - use: optional
     * @var string
     */
    public $StateProv;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: The country in which the reference point is located.
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for RefPoint
     * @uses RefPoint::setStateProv()
     * @uses RefPoint::setCountryCode()
     * @param string $stateProv
     * @param string $countryCode
     */
    public function __construct($stateProv = null, $countryCode = null)
    {
        $this
            ->setStateProv($stateProv)
            ->setCountryCode($countryCode);
    }
    /**
     * Get StateProv value
     * @return string|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param string $stateProv
     * @return \StructType\RefPoint
     */
    public function setStateProv($stateProv = null)
    {
        // validation for constraint: string
        if (!is_null($stateProv) && !is_string($stateProv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateProv)), __LINE__);
        }
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\RefPoint
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RefPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
