<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequests StructType
 * Meta informations extracted from the WSDL
 * - documentation: A grouping of Read Requests
 * @subpackage Structs
 */
class ReadRequests extends AbstractStructBase
{
    /**
     * The ReadRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReadRequest[]
     */
    public $ReadRequest;
    /**
     * The GlobalReservationReadRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GlobalReservationReadRequest[]
     */
    public $GlobalReservationReadRequest;
    /**
     * The AirReadRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirReadRequest[]
     */
    public $AirReadRequest;
    /**
     * Constructor method for ReadRequests
     * @uses ReadRequests::setReadRequest()
     * @uses ReadRequests::setGlobalReservationReadRequest()
     * @uses ReadRequests::setAirReadRequest()
     * @param \StructType\ReadRequest[] $readRequest
     * @param \StructType\GlobalReservationReadRequest[] $globalReservationReadRequest
     * @param \StructType\AirReadRequest[] $airReadRequest
     */
    public function __construct(array $readRequest = array(), array $globalReservationReadRequest = array(), array $airReadRequest = array())
    {
        $this
            ->setReadRequest($readRequest)
            ->setGlobalReservationReadRequest($globalReservationReadRequest)
            ->setAirReadRequest($airReadRequest);
    }
    /**
     * Get ReadRequest value
     * @return \StructType\ReadRequest[]|null
     */
    public function getReadRequest()
    {
        return $this->ReadRequest;
    }
    /**
     * Set ReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ReadRequest[] $readRequest
     * @return \StructType\ReadRequests
     */
    public function setReadRequest(array $readRequest = array())
    {
        foreach ($readRequest as $readRequestsReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsReadRequestItem instanceof \StructType\ReadRequest) {
                throw new \InvalidArgumentException(sprintf('The ReadRequest property can only contain items of \StructType\ReadRequest, "%s" given', is_object($readRequestsReadRequestItem) ? get_class($readRequestsReadRequestItem) : gettype($readRequestsReadRequestItem)), __LINE__);
            }
        }
        $this->ReadRequest = $readRequest;
        return $this;
    }
    /**
     * Add item to ReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToReadRequest(\StructType\ReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReadRequest) {
            throw new \InvalidArgumentException(sprintf('The ReadRequest property can only contain items of \StructType\ReadRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReadRequest[] = $item;
        return $this;
    }
    /**
     * Get GlobalReservationReadRequest value
     * @return \StructType\GlobalReservationReadRequest[]|null
     */
    public function getGlobalReservationReadRequest()
    {
        return $this->GlobalReservationReadRequest;
    }
    /**
     * Set GlobalReservationReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservationReadRequest[] $globalReservationReadRequest
     * @return \StructType\ReadRequests
     */
    public function setGlobalReservationReadRequest(array $globalReservationReadRequest = array())
    {
        foreach ($globalReservationReadRequest as $readRequestsGlobalReservationReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsGlobalReservationReadRequestItem instanceof \StructType\GlobalReservationReadRequest) {
                throw new \InvalidArgumentException(sprintf('The GlobalReservationReadRequest property can only contain items of \StructType\GlobalReservationReadRequest, "%s" given', is_object($readRequestsGlobalReservationReadRequestItem) ? get_class($readRequestsGlobalReservationReadRequestItem) : gettype($readRequestsGlobalReservationReadRequestItem)), __LINE__);
            }
        }
        $this->GlobalReservationReadRequest = $globalReservationReadRequest;
        return $this;
    }
    /**
     * Add item to GlobalReservationReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservationReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToGlobalReservationReadRequest(\StructType\GlobalReservationReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GlobalReservationReadRequest) {
            throw new \InvalidArgumentException(sprintf('The GlobalReservationReadRequest property can only contain items of \StructType\GlobalReservationReadRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GlobalReservationReadRequest[] = $item;
        return $this;
    }
    /**
     * Get AirReadRequest value
     * @return \StructType\AirReadRequest[]|null
     */
    public function getAirReadRequest()
    {
        return $this->AirReadRequest;
    }
    /**
     * Set AirReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReadRequest[] $airReadRequest
     * @return \StructType\ReadRequests
     */
    public function setAirReadRequest(array $airReadRequest = array())
    {
        foreach ($airReadRequest as $readRequestsAirReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsAirReadRequestItem instanceof \StructType\AirReadRequest) {
                throw new \InvalidArgumentException(sprintf('The AirReadRequest property can only contain items of \StructType\AirReadRequest, "%s" given', is_object($readRequestsAirReadRequestItem) ? get_class($readRequestsAirReadRequestItem) : gettype($readRequestsAirReadRequestItem)), __LINE__);
            }
        }
        $this->AirReadRequest = $airReadRequest;
        return $this;
    }
    /**
     * Add item to AirReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToAirReadRequest(\StructType\AirReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirReadRequest) {
            throw new \InvalidArgumentException(sprintf('The AirReadRequest property can only contain items of \StructType\AirReadRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AirReadRequest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
