<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: A request to read a reservation when the booking reference is known.
 * @subpackage Structs
 */
class ReadRequest extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - documentation: The booking reference for the reservation.
     * @var \StructType\UniqueID_Type
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta informations extracted from the WSDL
     * - documentation: This is to be used for verification that the record being sent is the specific record requested. This is optional and is intended to provide a more secure mechanism to ensure the correct record is being sent.
     * - minOccurs: 0
     * @var \StructType\VerificationType
     */
    public $Verification;
    /**
     * Constructor method for ReadRequest
     * @uses ReadRequest::setUniqueID()
     * @uses ReadRequest::setVerification()
     * @param \StructType\UniqueID_Type $uniqueID
     * @param \StructType\VerificationType $verification
     */
    public function __construct(\StructType\UniqueID_Type $uniqueID = null, \StructType\VerificationType $verification = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setVerification($verification);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \StructType\UniqueID_Type $uniqueID
     * @return \StructType\ReadRequest
     */
    public function setUniqueID(\StructType\UniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Verification value
     * @return \StructType\VerificationType|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @param \StructType\VerificationType $verification
     * @return \StructType\ReadRequest
     */
    public function setVerification(\StructType\VerificationType $verification = null)
    {
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
