<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Queue StructType
 * Meta informations extracted from the WSDL
 * - documentation: Specifies information necessary to place this booking on a particular host system queue. | Specifies queue information. | Specifies queue information for this booking.
 * @subpackage Structs
 */
class Queue extends AbstractStructBase
{
    /**
     * The QueueNumber
     * Meta informations extracted from the WSDL
     * - documentation: A number specifying the requested queue in which the PNR should be placed in the host system. | An identifier specifying the requested queue on which the booking file resides in the system. | A number specifying the requested queue
     * in which the PNR should be placed in the host system.
     * - use: required
     * @var string
     */
    public $QueueNumber;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: A 3 character ATA/IATA airport/city code of the system that delivers themessage. | An ATA/IATA airport/city code, office code, pseudo city code, etc. of the queue to be returned. If this is omitted, the pseudo city code contained in
     * the point of sale information should be used. | A 3 character ATA/IATA airport/city code of the system that delivers themessage.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueCategory
     * Meta informations extracted from the WSDL
     * - documentation: A subdivision of a particular queue used to provide additional functional granularity. | A subdivision of a particular queue used to provide additional functional granularity.
     * @var string
     */
    public $QueueCategory;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - documentation: Date/time when the time initiated queuing should take place. | Date/time when the time initiated queuing should take place.
     * - use: optional
     * @var string
     */
    public $DateTime;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Text describing why the queuing takes place. | Text describing why the queuing takes place.
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The CarrierCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies airline/system on which the reservation is being queued. | Identifies airline/system on which the reservation is being queued.
     * - use: optional
     * @var string
     */
    public $CarrierCode;
    /**
     * The SystemCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the airline and/or system where the queue resides. If this is omitted, the airline and/or system code (AirlineVendorID) contained in the point of sale information should be used. | Used for Character Strings, length 1 to 8
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $SystemCode;
    /**
     * Constructor method for Queue
     * @uses Queue::setQueueNumber()
     * @uses Queue::setPseudoCityCode()
     * @uses Queue::setQueueCategory()
     * @uses Queue::setDateTime()
     * @uses Queue::setText()
     * @uses Queue::setCarrierCode()
     * @uses Queue::setSystemCode()
     * @param string $queueNumber
     * @param string $pseudoCityCode
     * @param string $queueCategory
     * @param string $dateTime
     * @param string $text
     * @param string $carrierCode
     * @param string $systemCode
     */
    public function __construct($queueNumber = null, $pseudoCityCode = null, $queueCategory = null, $dateTime = null, $text = null, $carrierCode = null, $systemCode = null)
    {
        $this
            ->setQueueNumber($queueNumber)
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueCategory($queueCategory)
            ->setDateTime($dateTime)
            ->setText($text)
            ->setCarrierCode($carrierCode)
            ->setSystemCode($systemCode);
    }
    /**
     * Get QueueNumber value
     * @return string
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \StructType\Queue
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueNumber)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \StructType\Queue
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueCategory value
     * @return string|null
     */
    public function getQueueCategory()
    {
        return $this->QueueCategory;
    }
    /**
     * Set QueueCategory value
     * @param string $queueCategory
     * @return \StructType\Queue
     */
    public function setQueueCategory($queueCategory = null)
    {
        // validation for constraint: string
        if (!is_null($queueCategory) && !is_string($queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueCategory)), __LINE__);
        }
        $this->QueueCategory = $queueCategory;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\Queue
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\Queue
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\Queue
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return string|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param string $systemCode
     * @return \StructType\Queue
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($systemCode) && strlen($systemCode) > 8) || (is_array($systemCode) && count($systemCode) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($systemCode) ? strlen($systemCode) : count($systemCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($systemCode) && strlen($systemCode) < 1) || (is_array($systemCode) && count($systemCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Queue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
