<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identify pricing source, if negotiated fares are requested and if it is a reprice request. | Used to describe a price request.
 * @subpackage Structs
 */
class PriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NegotiatedFareCode[]
     */
    public $NegotiatedFareCode;
    /**
     * The CabinType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the type of cabin (i.e., first, business, economy) requested.
     * - use: optional
     * @var string
     */
    public $CabinType;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses PriceRequestInformationType::setNegotiatedFareCode()
     * @uses PriceRequestInformationType::setCabinType()
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @param string $cabinType
     */
    public function __construct(array $negotiatedFareCode = array(), $cabinType = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setCabinType($cabinType);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \StructType\NegotiatedFareCode[]|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode[] $negotiatedFareCode
     * @return \StructType\PriceRequestInformationType
     */
    public function setNegotiatedFareCode(array $negotiatedFareCode = array())
    {
        foreach ($negotiatedFareCode as $priceRequestInformationTypeNegotiatedFareCodeItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeNegotiatedFareCodeItem instanceof \StructType\NegotiatedFareCode) {
                throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of \StructType\NegotiatedFareCode, "%s" given', is_object($priceRequestInformationTypeNegotiatedFareCodeItem) ? get_class($priceRequestInformationTypeNegotiatedFareCodeItem) : gettype($priceRequestInformationTypeNegotiatedFareCodeItem)), __LINE__);
            }
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Add item to NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\NegotiatedFareCode $item
     * @return \StructType\PriceRequestInformationType
     */
    public function addToNegotiatedFareCode(\StructType\NegotiatedFareCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NegotiatedFareCode) {
            throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of \StructType\NegotiatedFareCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NegotiatedFareCode[] = $item;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @param string $cabinType
     * @return \StructType\PriceRequestInformationType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: string
        if (!is_null($cabinType) && !is_string($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinType)), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PriceRequestInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
