<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanForQuoteRS StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains a quote response for a single insurance plan.
 * @subpackage Structs
 */
class PlanForQuoteRS extends AbstractStructBase
{
    /**
     * The QuoteDetail
     * @var \StructType\QuoteDetail
     */
    public $QuoteDetail;
    /**
     * The InsCoverageDetail
     * Meta informations extracted from the WSDL
     * - documentation: Allows vendor to echo back information about the traveler(s)' requirements for insurance coverage.
     * - minOccurs: 0
     * @var \StructType\InsCoverageDetailType
     */
    public $InsCoverageDetail;
    /**
     * The PlanCost
     * Meta informations extracted from the WSDL
     * - documentation: Contains information about the total price of the insurance plan.
     * @var \StructType\PlanCostType
     */
    public $PlanCost;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - documentation: Defines contact information for an individual or company (for example, the provider's callcenter number or claims hotline).
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\ContactPersonType[]
     */
    public $Contact;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * @var string
     */
    public $RPH;
    /**
     * The PlanID
     * @var string
     */
    public $PlanID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The TypeID
     * @var string
     */
    public $TypeID;
    /**
     * Constructor method for PlanForQuoteRS
     * @uses PlanForQuoteRS::setQuoteDetail()
     * @uses PlanForQuoteRS::setInsCoverageDetail()
     * @uses PlanForQuoteRS::setPlanCost()
     * @uses PlanForQuoteRS::setContact()
     * @uses PlanForQuoteRS::setRPH()
     * @uses PlanForQuoteRS::setPlanID()
     * @uses PlanForQuoteRS::setName()
     * @uses PlanForQuoteRS::setType()
     * @uses PlanForQuoteRS::setTypeID()
     * @param \StructType\QuoteDetail $quoteDetail
     * @param \StructType\InsCoverageDetailType $insCoverageDetail
     * @param \StructType\PlanCostType $planCost
     * @param \StructType\ContactPersonType[] $contact
     * @param string $rPH
     * @param string $planID
     * @param string $name
     * @param string $type
     * @param string $typeID
     */
    public function __construct(\StructType\QuoteDetail $quoteDetail = null, \StructType\InsCoverageDetailType $insCoverageDetail = null, \StructType\PlanCostType $planCost = null, array $contact = array(), $rPH = null, $planID = null, $name = null, $type = null, $typeID = null)
    {
        $this
            ->setQuoteDetail($quoteDetail)
            ->setInsCoverageDetail($insCoverageDetail)
            ->setPlanCost($planCost)
            ->setContact($contact)
            ->setRPH($rPH)
            ->setPlanID($planID)
            ->setName($name)
            ->setType($type)
            ->setTypeID($typeID);
    }
    /**
     * Get QuoteDetail value
     * @return \StructType\QuoteDetail|null
     */
    public function getQuoteDetail()
    {
        return $this->QuoteDetail;
    }
    /**
     * Set QuoteDetail value
     * @param \StructType\QuoteDetail $quoteDetail
     * @return \StructType\PlanForQuoteRS
     */
    public function setQuoteDetail(\StructType\QuoteDetail $quoteDetail = null)
    {
        $this->QuoteDetail = $quoteDetail;
        return $this;
    }
    /**
     * Get InsCoverageDetail value
     * @return \StructType\InsCoverageDetailType|null
     */
    public function getInsCoverageDetail()
    {
        return $this->InsCoverageDetail;
    }
    /**
     * Set InsCoverageDetail value
     * @param \StructType\InsCoverageDetailType $insCoverageDetail
     * @return \StructType\PlanForQuoteRS
     */
    public function setInsCoverageDetail(\StructType\InsCoverageDetailType $insCoverageDetail = null)
    {
        $this->InsCoverageDetail = $insCoverageDetail;
        return $this;
    }
    /**
     * Get PlanCost value
     * @return \StructType\PlanCostType|null
     */
    public function getPlanCost()
    {
        return $this->PlanCost;
    }
    /**
     * Set PlanCost value
     * @param \StructType\PlanCostType $planCost
     * @return \StructType\PlanForQuoteRS
     */
    public function setPlanCost(\StructType\PlanCostType $planCost = null)
    {
        $this->PlanCost = $planCost;
        return $this;
    }
    /**
     * Get Contact value
     * @return \StructType\ContactPersonType[]|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType[] $contact
     * @return \StructType\PlanForQuoteRS
     */
    public function setContact(array $contact = array())
    {
        foreach ($contact as $planForQuoteRSContactItem) {
            // validation for constraint: itemType
            if (!$planForQuoteRSContactItem instanceof \StructType\ContactPersonType) {
                throw new \InvalidArgumentException(sprintf('The Contact property can only contain items of \StructType\ContactPersonType, "%s" given', is_object($planForQuoteRSContactItem) ? get_class($planForQuoteRSContactItem) : gettype($planForQuoteRSContactItem)), __LINE__);
            }
        }
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Add item to Contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPersonType $item
     * @return \StructType\PlanForQuoteRS
     */
    public function addToContact(\StructType\ContactPersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactPersonType) {
            throw new \InvalidArgumentException(sprintf('The Contact property can only contain items of \StructType\ContactPersonType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Contact[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PlanForQuoteRS
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PlanID value
     * @return string|null
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param string $planID
     * @return \StructType\PlanForQuoteRS
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: string
        if (!is_null($planID) && !is_string($planID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PlanForQuoteRS
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\PlanForQuoteRS
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeID value
     * @return string|null
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param string $typeID
     * @return \StructType\PlanForQuoteRS
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: string
        if (!is_null($typeID) && !is_string($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanForQuoteRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
