<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PerPaxFlexiFareAmount StructType
 * Meta informations extracted from the WSDL
 * - documentation: The amount the passenger would have to pay for this flexibile fare.
 * @subpackage Structs
 */
class PerPaxFlexiFareAmount extends AbstractStructBase
{
    /**
     * The ApplicablePaxType
     * Meta informations extracted from the WSDL
     * - documentation: The type of passenger the flexible fare applies to.
     * @var string
     */
    public $ApplicablePaxType;
    /**
     * Constructor method for PerPaxFlexiFareAmount
     * @uses PerPaxFlexiFareAmount::setApplicablePaxType()
     * @param string $applicablePaxType
     */
    public function __construct($applicablePaxType = null)
    {
        $this
            ->setApplicablePaxType($applicablePaxType);
    }
    /**
     * Get ApplicablePaxType value
     * @return string|null
     */
    public function getApplicablePaxType()
    {
        return $this->ApplicablePaxType;
    }
    /**
     * Set ApplicablePaxType value
     * @param string $applicablePaxType
     * @return \StructType\PerPaxFlexiFareAmount
     */
    public function setApplicablePaxType($applicablePaxType = null)
    {
        // validation for constraint: string
        if (!is_null($applicablePaxType) && !is_string($applicablePaxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicablePaxType)), __LINE__);
        }
        $this->ApplicablePaxType = $applicablePaxType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PerPaxFlexiFareAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
