<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTransaction StructType
 * @subpackage Structs
 */
class PaymentTransaction extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The BankRefNo
     * @var string
     */
    public $BankRefNo;
    /**
     * The AARefNo
     * @var string
     */
    public $AARefNo;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The BankChannel
     * @var string
     */
    public $BankChannel;
    /**
     * The AAStatus
     * @var string
     */
    public $AAStatus;
    /**
     * The BankStatus
     * @var string
     */
    public $BankStatus;
    /**
     * Constructor method for PaymentTransaction
     * @uses PaymentTransaction::setAmount()
     * @uses PaymentTransaction::setBankRefNo()
     * @uses PaymentTransaction::setAARefNo()
     * @uses PaymentTransaction::setTimestamp()
     * @uses PaymentTransaction::setBankChannel()
     * @uses PaymentTransaction::setAAStatus()
     * @uses PaymentTransaction::setBankStatus()
     * @param float $amount
     * @param string $bankRefNo
     * @param string $aARefNo
     * @param string $timestamp
     * @param string $bankChannel
     * @param string $aAStatus
     * @param string $bankStatus
     */
    public function __construct($amount = null, $bankRefNo = null, $aARefNo = null, $timestamp = null, $bankChannel = null, $aAStatus = null, $bankStatus = null)
    {
        $this
            ->setAmount($amount)
            ->setBankRefNo($bankRefNo)
            ->setAARefNo($aARefNo)
            ->setTimestamp($timestamp)
            ->setBankChannel($bankChannel)
            ->setAAStatus($aAStatus)
            ->setBankStatus($bankStatus);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PaymentTransaction
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get BankRefNo value
     * @return string|null
     */
    public function getBankRefNo()
    {
        return $this->BankRefNo;
    }
    /**
     * Set BankRefNo value
     * @param string $bankRefNo
     * @return \StructType\PaymentTransaction
     */
    public function setBankRefNo($bankRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankRefNo) && !is_string($bankRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRefNo)), __LINE__);
        }
        $this->BankRefNo = $bankRefNo;
        return $this;
    }
    /**
     * Get AARefNo value
     * @return string|null
     */
    public function getAARefNo()
    {
        return $this->AARefNo;
    }
    /**
     * Set AARefNo value
     * @param string $aARefNo
     * @return \StructType\PaymentTransaction
     */
    public function setAARefNo($aARefNo = null)
    {
        // validation for constraint: string
        if (!is_null($aARefNo) && !is_string($aARefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aARefNo)), __LINE__);
        }
        $this->AARefNo = $aARefNo;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\PaymentTransaction
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get BankChannel value
     * @return string|null
     */
    public function getBankChannel()
    {
        return $this->BankChannel;
    }
    /**
     * Set BankChannel value
     * @param string $bankChannel
     * @return \StructType\PaymentTransaction
     */
    public function setBankChannel($bankChannel = null)
    {
        // validation for constraint: string
        if (!is_null($bankChannel) && !is_string($bankChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankChannel)), __LINE__);
        }
        $this->BankChannel = $bankChannel;
        return $this;
    }
    /**
     * Get AAStatus value
     * @return string|null
     */
    public function getAAStatus()
    {
        return $this->AAStatus;
    }
    /**
     * Set AAStatus value
     * @param string $aAStatus
     * @return \StructType\PaymentTransaction
     */
    public function setAAStatus($aAStatus = null)
    {
        // validation for constraint: string
        if (!is_null($aAStatus) && !is_string($aAStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aAStatus)), __LINE__);
        }
        $this->AAStatus = $aAStatus;
        return $this;
    }
    /**
     * Get BankStatus value
     * @return string|null
     */
    public function getBankStatus()
    {
        return $this->BankStatus;
    }
    /**
     * Set BankStatus value
     * @param string $bankStatus
     * @return \StructType\PaymentTransaction
     */
    public function setBankStatus($bankStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bankStatus) && !is_string($bankStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankStatus)), __LINE__);
        }
        $this->BankStatus = $bankStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
