<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pax StructType
 * @subpackage Structs
 */
class Pax extends AbstractStructBase
{
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The typeCode
     * @var string
     */
    public $typeCode;
    /**
     * Constructor method for pax
     * @uses Pax::setRPH()
     * @uses Pax::setName()
     * @uses Pax::setTypeCode()
     * @param string $rPH
     * @param string $name
     * @param string $typeCode
     */
    public function __construct($rPH = null, $name = null, $typeCode = null)
    {
        $this
            ->setRPH($rPH)
            ->setName($name)
            ->setTypeCode($typeCode);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\Pax
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Pax
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get typeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->typeCode;
    }
    /**
     * Set typeCode value
     * @param string $typeCode
     * @return \StructType\Pax
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->typeCode = $typeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Pax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
