<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTCFareBreakdownType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Per passenger type code pricing for this itinerary. Set if fareBreakdown was requested.
 * @subpackage Structs
 */
class PTCFareBreakdownType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Number of individuals traveling under this PTC
     * @var mixed
     */
    public $PassengerTypeQuantity;
    /**
     * The FareBasisCodes
     * @var \StructType\FareBasisCodes
     */
    public $FareBasisCodes;
    /**
     * The PassengerFare
     * Meta informations extracted from the WSDL
     * - documentation: The total passenger fare with cost breakdown.
     * @var mixed
     */
    public $PassengerFare;
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The TicketDesignators
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TicketDesignators
     */
    public $TicketDesignators;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Endorsements
     */
    public $Endorsements;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FareInfo[]
     */
    public $FareInfo;
    /**
     * The PricingSource
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether the fare is public, private or both.
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * Constructor method for PTCFareBreakdownType
     * @uses PTCFareBreakdownType::setPassengerTypeQuantity()
     * @uses PTCFareBreakdownType::setFareBasisCodes()
     * @uses PTCFareBreakdownType::setPassengerFare()
     * @uses PTCFareBreakdownType::setTravelerRefNumber()
     * @uses PTCFareBreakdownType::setTicketDesignators()
     * @uses PTCFareBreakdownType::setEndorsements()
     * @uses PTCFareBreakdownType::setFareInfo()
     * @uses PTCFareBreakdownType::setPricingSource()
     * @param mixed $passengerTypeQuantity
     * @param \StructType\FareBasisCodes $fareBasisCodes
     * @param mixed $passengerFare
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @param \StructType\TicketDesignators $ticketDesignators
     * @param \StructType\Endorsements $endorsements
     * @param \StructType\FareInfo[] $fareInfo
     * @param string $pricingSource
     */
    public function __construct($passengerTypeQuantity = null, \StructType\FareBasisCodes $fareBasisCodes = null, $passengerFare = null, array $travelerRefNumber = array(), \StructType\TicketDesignators $ticketDesignators = null, \StructType\Endorsements $endorsements = null, array $fareInfo = array(), $pricingSource = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setFareBasisCodes($fareBasisCodes)
            ->setPassengerFare($passengerFare)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setTicketDesignators($ticketDesignators)
            ->setEndorsements($endorsements)
            ->setFareInfo($fareInfo)
            ->setPricingSource($pricingSource);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return mixed|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param mixed $passengerTypeQuantity
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPassengerTypeQuantity($passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get FareBasisCodes value
     * @return \StructType\FareBasisCodes|null
     */
    public function getFareBasisCodes()
    {
        return $this->FareBasisCodes;
    }
    /**
     * Set FareBasisCodes value
     * @param \StructType\FareBasisCodes $fareBasisCodes
     * @return \StructType\PTCFareBreakdownType
     */
    public function setFareBasisCodes(\StructType\FareBasisCodes $fareBasisCodes = null)
    {
        $this->FareBasisCodes = $fareBasisCodes;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return mixed|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param mixed $passengerFare
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPassengerFare($passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \StructType\TravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber[] $travelerRefNumber
     * @return \StructType\PTCFareBreakdownType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        foreach ($travelerRefNumber as $pTCFareBreakdownTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeTravelerRefNumberItem instanceof \StructType\TravelerRefNumber) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \StructType\TravelerRefNumber, "%s" given', is_object($pTCFareBreakdownTypeTravelerRefNumberItem) ? get_class($pTCFareBreakdownTypeTravelerRefNumberItem) : gettype($pTCFareBreakdownTypeTravelerRefNumberItem)), __LINE__);
            }
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerRefNumber $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToTravelerRefNumber(\StructType\TravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \StructType\TravelerRefNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get TicketDesignators value
     * @return \StructType\TicketDesignators|null
     */
    public function getTicketDesignators()
    {
        return $this->TicketDesignators;
    }
    /**
     * Set TicketDesignators value
     * @param \StructType\TicketDesignators $ticketDesignators
     * @return \StructType\PTCFareBreakdownType
     */
    public function setTicketDesignators(\StructType\TicketDesignators $ticketDesignators = null)
    {
        $this->TicketDesignators = $ticketDesignators;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \StructType\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \StructType\Endorsements $endorsements
     * @return \StructType\PTCFareBreakdownType
     */
    public function setEndorsements(\StructType\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo[] $fareInfo
     * @return \StructType\PTCFareBreakdownType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        foreach ($fareInfo as $pTCFareBreakdownTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeFareInfoItem instanceof \StructType\FareInfo) {
                throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \StructType\FareInfo, "%s" given', is_object($pTCFareBreakdownTypeFareInfoItem) ? get_class($pTCFareBreakdownTypeFareInfoItem) : gettype($pTCFareBreakdownTypeFareInfoItem)), __LINE__);
            }
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo $item
     * @return \StructType\PTCFareBreakdownType
     */
    public function addToFareInfo(\StructType\FareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \StructType\FareInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @param string $pricingSource
     * @return \StructType\PTCFareBreakdownType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: string
        if (!is_null($pricingSource) && !is_string($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pricingSource)), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PTCFareBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
