<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOption StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds the collection of flight options for this origin-destination pair. There maybe limits imposed by individual supplier that are below the maximum occurrences for this element. | Holds the collection of flight options for this
 * origin-destination pair. There maybe limits imposed by individual supplier that are below the maximum occurrences for this element.
 * @subpackage Structs
 */
class OriginDestinationOption extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * @var \StructType\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * Constructor method for OriginDestinationOption
     * @uses OriginDestinationOption::setFlightSegment()
     * @param \StructType\FlightSegment[] $flightSegment
     */
    public function __construct(array $flightSegment = array())
    {
        $this
            ->setFlightSegment($flightSegment);
    }
    /**
     * Get FlightSegment value
     * @return \StructType\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightSegment[] $flightSegment
     * @return \StructType\OriginDestinationOption
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        foreach ($flightSegment as $originDestinationOptionFlightSegmentItem) {
            // validation for constraint: itemType
            if (!$originDestinationOptionFlightSegmentItem instanceof \StructType\FlightSegment) {
                throw new \InvalidArgumentException(sprintf('The FlightSegment property can only contain items of \StructType\FlightSegment, "%s" given', is_object($originDestinationOptionFlightSegmentItem) ? get_class($originDestinationOptionFlightSegmentItem) : gettype($originDestinationOptionFlightSegmentItem)), __LINE__);
            }
        }
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightSegment $item
     * @return \StructType\OriginDestinationOption
     */
    public function addToFlightSegment(\StructType\FlightSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightSegment) {
            throw new \InvalidArgumentException(sprintf('The FlightSegment property can only contain items of \StructType\FlightSegment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
