<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information on the locations between which availability is to be checked. | Information on the locations between which availability was requested.
 * @subpackage Structs
 */
class OriginDestinationInformation extends OriginDestinationInformationType
{
    /**
     * The SpecificFlightInfo
     * Meta informations extracted from the WSDL
     * - documentation: To specify a flight for this origin and destination for which availability is to be checked.
     * - minOccurs: 0
     * @var \StructType\SpecificFlightInfoType
     */
    public $SpecificFlightInfo;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Traveler preference information for this particular origin and destination.
     * - minOccurs: 0
     * @var \StructType\AirSearchPrefsType
     */
    public $TravelPreferences;
    /**
     * The SameAirportInd
     * Meta informations extracted from the WSDL
     * - documentation: If true, the return departure must be from the same airport as the outbound arrival. | If true, the return departure must be from the same airport as the outbound arrival.
     * - use: optional
     * @var bool
     */
    public $SameAirportInd;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: Uniquely identifies this origin destination information. | Uniquely identifies this origin destination information. | (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used
     * to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The OriginDestinationOptions
     * @var \StructType\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * Constructor method for OriginDestinationInformation
     * @uses OriginDestinationInformation::setSpecificFlightInfo()
     * @uses OriginDestinationInformation::setTravelPreferences()
     * @uses OriginDestinationInformation::setSameAirportInd()
     * @uses OriginDestinationInformation::setRPH()
     * @uses OriginDestinationInformation::setOriginDestinationOptions()
     * @param \StructType\SpecificFlightInfoType $specificFlightInfo
     * @param \StructType\AirSearchPrefsType $travelPreferences
     * @param bool $sameAirportInd
     * @param string $rPH
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     */
    public function __construct(\StructType\SpecificFlightInfoType $specificFlightInfo = null, \StructType\AirSearchPrefsType $travelPreferences = null, $sameAirportInd = null, $rPH = null, \StructType\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this
            ->setSpecificFlightInfo($specificFlightInfo)
            ->setTravelPreferences($travelPreferences)
            ->setSameAirportInd($sameAirportInd)
            ->setRPH($rPH)
            ->setOriginDestinationOptions($originDestinationOptions);
    }
    /**
     * Get SpecificFlightInfo value
     * @return \StructType\SpecificFlightInfoType|null
     */
    public function getSpecificFlightInfo()
    {
        return $this->SpecificFlightInfo;
    }
    /**
     * Set SpecificFlightInfo value
     * @param \StructType\SpecificFlightInfoType $specificFlightInfo
     * @return \StructType\OriginDestinationInformation
     */
    public function setSpecificFlightInfo(\StructType\SpecificFlightInfoType $specificFlightInfo = null)
    {
        $this->SpecificFlightInfo = $specificFlightInfo;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \StructType\AirSearchPrefsType|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @param \StructType\AirSearchPrefsType $travelPreferences
     * @return \StructType\OriginDestinationInformation
     */
    public function setTravelPreferences(\StructType\AirSearchPrefsType $travelPreferences = null)
    {
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Get SameAirportInd value
     * @return bool|null
     */
    public function getSameAirportInd()
    {
        return $this->SameAirportInd;
    }
    /**
     * Set SameAirportInd value
     * @param bool $sameAirportInd
     * @return \StructType\OriginDestinationInformation
     */
    public function setSameAirportInd($sameAirportInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameAirportInd) && !is_bool($sameAirportInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sameAirportInd)), __LINE__);
        }
        $this->SameAirportInd = $sameAirportInd;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\OriginDestinationInformation
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get OriginDestinationOptions value
     * @return \StructType\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     * @return \StructType\OriginDestinationInformation
     */
    public function setOriginDestinationOptions(\StructType\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OriginDestinationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
