<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_ResRetrieveRS StructType
 * Meta informations extracted from the WSDL
 * - documentation: This message returns a list of reservations when an exact match on a read request could not be made or the request was to return a list of reservations meeting specified criteria. | Use the MoreDataEchoToken to indicate the last
 * record in the list. Used in subsequent requests, to identify where the last response left off.
 * @subpackage Structs
 */
class OTA_ResRetrieveRS extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - documentation: The presence of the empty Success element explicitly indicates that the OTA versioned message succeeded.
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - documentation: Used in conjunction with the Success element to define one or more business errors.
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The ReservationsList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReservationsList
     */
    public $ReservationsList;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - documentation: Errors is returned if the request was unable to be processed.
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The MoreIndicator
     * @var bool
     */
    public $MoreIndicator;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * Constructor method for OTA_ResRetrieveRS
     * @uses OTA_ResRetrieveRS::setSuccess()
     * @uses OTA_ResRetrieveRS::setWarnings()
     * @uses OTA_ResRetrieveRS::setReservationsList()
     * @uses OTA_ResRetrieveRS::setErrors()
     * @uses OTA_ResRetrieveRS::setEchoToken()
     * @uses OTA_ResRetrieveRS::setTimeStamp()
     * @uses OTA_ResRetrieveRS::setTarget()
     * @uses OTA_ResRetrieveRS::setVersion()
     * @uses OTA_ResRetrieveRS::setTransactionIdentifier()
     * @uses OTA_ResRetrieveRS::setSequenceNmbr()
     * @uses OTA_ResRetrieveRS::setTransactionStatusCode()
     * @uses OTA_ResRetrieveRS::setRetransmissionIndicator()
     * @uses OTA_ResRetrieveRS::setMoreIndicator()
     * @uses OTA_ResRetrieveRS::setMoreDataEchoToken()
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\ReservationsList $reservationsList
     * @param \StructType\ErrorsType $errors
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param bool $moreIndicator
     * @param string $moreDataEchoToken
     */
    public function __construct(\StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\ReservationsList $reservationsList = null, \StructType\ErrorsType $errors = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $moreIndicator = null, $moreDataEchoToken = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setReservationsList($reservationsList)
            ->setErrors($errors)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setMoreIndicator($moreIndicator)
            ->setMoreDataEchoToken($moreDataEchoToken);
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get ReservationsList value
     * @return \StructType\ReservationsList|null
     */
    public function getReservationsList()
    {
        return $this->ReservationsList;
    }
    /**
     * Set ReservationsList value
     * @param \StructType\ReservationsList $reservationsList
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setReservationsList(\StructType\ReservationsList $reservationsList = null)
    {
        $this->ReservationsList = $reservationsList;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get MoreIndicator value
     * @return bool|null
     */
    public function getMoreIndicator()
    {
        return $this->MoreIndicator;
    }
    /**
     * Set MoreIndicator value
     * @param bool $moreIndicator
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setMoreIndicator($moreIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreIndicator) && !is_bool($moreIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreIndicator)), __LINE__);
        }
        $this->MoreIndicator = $moreIndicator;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_ResRetrieveRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
