<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_InsuranceQuoteRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for insurance quote requests
 * @subpackage Structs
 */
class OTA_InsuranceQuoteRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Container for any Point-of-sale information.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The PlanForQuoteRQ
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PlanForQuoteRQ[]
     */
    public $PlanForQuoteRQ;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_InsuranceQuoteRQ
     * @uses OTA_InsuranceQuoteRQ::setPOS()
     * @uses OTA_InsuranceQuoteRQ::setPlanForQuoteRQ()
     * @uses OTA_InsuranceQuoteRQ::setEchoToken()
     * @uses OTA_InsuranceQuoteRQ::setTimeStamp()
     * @uses OTA_InsuranceQuoteRQ::setTarget()
     * @uses OTA_InsuranceQuoteRQ::setVersion()
     * @uses OTA_InsuranceQuoteRQ::setTransactionIdentifier()
     * @uses OTA_InsuranceQuoteRQ::setSequenceNmbr()
     * @uses OTA_InsuranceQuoteRQ::setTransactionStatusCode()
     * @uses OTA_InsuranceQuoteRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\PlanForQuoteRQ[] $planForQuoteRQ
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, array $planForQuoteRQ = array(), $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setPlanForQuoteRQ($planForQuoteRQ)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get PlanForQuoteRQ value
     * @return \StructType\PlanForQuoteRQ[]|null
     */
    public function getPlanForQuoteRQ()
    {
        return $this->PlanForQuoteRQ;
    }
    /**
     * Set PlanForQuoteRQ value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanForQuoteRQ[] $planForQuoteRQ
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setPlanForQuoteRQ(array $planForQuoteRQ = array())
    {
        foreach ($planForQuoteRQ as $oTA_InsuranceQuoteRQPlanForQuoteRQItem) {
            // validation for constraint: itemType
            if (!$oTA_InsuranceQuoteRQPlanForQuoteRQItem instanceof \StructType\PlanForQuoteRQ) {
                throw new \InvalidArgumentException(sprintf('The PlanForQuoteRQ property can only contain items of \StructType\PlanForQuoteRQ, "%s" given', is_object($oTA_InsuranceQuoteRQPlanForQuoteRQItem) ? get_class($oTA_InsuranceQuoteRQPlanForQuoteRQItem) : gettype($oTA_InsuranceQuoteRQPlanForQuoteRQItem)), __LINE__);
            }
        }
        $this->PlanForQuoteRQ = $planForQuoteRQ;
        return $this;
    }
    /**
     * Add item to PlanForQuoteRQ value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanForQuoteRQ $item
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function addToPlanForQuoteRQ(\StructType\PlanForQuoteRQ $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanForQuoteRQ) {
            throw new \InvalidArgumentException(sprintf('The PlanForQuoteRQ property can only contain items of \StructType\PlanForQuoteRQ, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlanForQuoteRQ[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_InsuranceQuoteRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
