<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirScheduleRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Schedule Request message requests Flight Schedules for a city pair. Optional request information can include:- Time / Time Window- Connecting cities.- Client Preferences (airlines, cabin, flight types etc.)The request can be
 * narrowed to request schedules for a specific airline or specific flight.
 * @subpackage Structs
 */
class OTA_AirScheduleRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: Point of sale object.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - documentation: Origin and Destination location, and time information for the Air Schedule request.
     * @var \StructType\OriginDestinationInformationType
     */
    public $OriginDestinationInformation;
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - documentation: Specific airline and flight number for which a schedule is being requested.
     * - minOccurs: 0
     * @var \StructType\SpecificFlightInfoType
     */
    public $FlightInfo;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - documentation: Specify vendors to include and exclude from the response.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\CompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - documentation: Equipment Preference to qualify Air Schedule request.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirScheduleRQ
     * @uses OTA_AirScheduleRQ::setPOS()
     * @uses OTA_AirScheduleRQ::setOriginDestinationInformation()
     * @uses OTA_AirScheduleRQ::setFlightInfo()
     * @uses OTA_AirScheduleRQ::setVendorPref()
     * @uses OTA_AirScheduleRQ::setFlightTypePref()
     * @uses OTA_AirScheduleRQ::setEquipPref()
     * @uses OTA_AirScheduleRQ::setEchoToken()
     * @uses OTA_AirScheduleRQ::setTimeStamp()
     * @uses OTA_AirScheduleRQ::setTarget()
     * @uses OTA_AirScheduleRQ::setVersion()
     * @uses OTA_AirScheduleRQ::setTransactionIdentifier()
     * @uses OTA_AirScheduleRQ::setSequenceNmbr()
     * @uses OTA_AirScheduleRQ::setTransactionStatusCode()
     * @uses OTA_AirScheduleRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\OriginDestinationInformationType $originDestinationInformation
     * @param \StructType\SpecificFlightInfoType $flightInfo
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @param \StructType\EquipmentTypePref[] $equipPref
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\OriginDestinationInformationType $originDestinationInformation = null, \StructType\SpecificFlightInfoType $flightInfo = null, array $vendorPref = array(), array $flightTypePref = array(), array $equipPref = array(), $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setFlightInfo($flightInfo)
            ->setVendorPref($vendorPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \StructType\OriginDestinationInformationType|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \StructType\OriginDestinationInformationType $originDestinationInformation
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setOriginDestinationInformation(\StructType\OriginDestinationInformationType $originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get FlightInfo value
     * @return \StructType\SpecificFlightInfoType|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param \StructType\SpecificFlightInfoType $flightInfo
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setFlightInfo(\StructType\SpecificFlightInfoType $flightInfo = null)
    {
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\CompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType[] $vendorPref
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $oTA_AirScheduleRQVendorPrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQVendorPrefItem instanceof \StructType\CompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \StructType\CompanyNamePrefType, "%s" given', is_object($oTA_AirScheduleRQVendorPrefItem) ? get_class($oTA_AirScheduleRQVendorPrefItem) : gettype($oTA_AirScheduleRQVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyNamePrefType $item
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function addToVendorPref(\StructType\CompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \StructType\CompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $oTA_AirScheduleRQFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQFlightTypePrefItem instanceof \StructType\FlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \StructType\FlightTypePref, "%s" given', is_object($oTA_AirScheduleRQFlightTypePrefItem) ? get_class($oTA_AirScheduleRQFlightTypePrefItem) : gettype($oTA_AirScheduleRQFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref $item
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function addToFlightTypePref(\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \StructType\FlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentTypePref[] $equipPref
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $oTA_AirScheduleRQEquipPrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQEquipPrefItem instanceof \StructType\EquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \StructType\EquipmentTypePref, "%s" given', is_object($oTA_AirScheduleRQEquipPrefItem) ? get_class($oTA_AirScheduleRQEquipPrefItem) : gettype($oTA_AirScheduleRQEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentTypePref $item
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function addToEquipPref(\StructType\EquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \StructType\EquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirScheduleRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirScheduleRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
