<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirBookRQ StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Book Request message requests the system to book a specific itinerary for one or more identified passengers. The message contains optional pricing information, allowing the booking class availability and pricing to be rechecked
 * as part of the booking process. Optional request information can include:- Seat and Meal Requests- SSR, OSI, and Remarks.
 * @subpackage Structs
 */
class OTA_AirBookRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - documentation: This identifes the party making the booking request. Trading partners are open to define their own UniqueID.
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - documentation: A collection of all flight segments requested for booking.
     * @var \StructType\AirItineraryType
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfo
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - documentation: All traveler information relevant to a booking request.
     * @var \StructType\TravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fulfillment
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - documentation: Information used to specify the ticketing arrangement.
     * - minOccurs: 0
     * @var \StructType\TicketingInfoType
     */
    public $Ticketing;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\Queue[]
     */
    public $Queue;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator.
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TravelersFulfillments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TravelersFulfillments
     * @var \StructType\TravelersFulfillments
     */
    public $TravelersFulfillments;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirBookRQ
     * @uses OTA_AirBookRQ::setPOS()
     * @uses OTA_AirBookRQ::setAirItinerary()
     * @uses OTA_AirBookRQ::setPriceInfo()
     * @uses OTA_AirBookRQ::setTravelerInfo()
     * @uses OTA_AirBookRQ::setFulfillment()
     * @uses OTA_AirBookRQ::setTicketing()
     * @uses OTA_AirBookRQ::setQueue()
     * @uses OTA_AirBookRQ::setBookingReferenceID()
     * @uses OTA_AirBookRQ::setTPA_Extensions()
     * @uses OTA_AirBookRQ::setTravelersFulfillments()
     * @uses OTA_AirBookRQ::setEchoToken()
     * @uses OTA_AirBookRQ::setTimeStamp()
     * @uses OTA_AirBookRQ::setTarget()
     * @uses OTA_AirBookRQ::setVersion()
     * @uses OTA_AirBookRQ::setTransactionIdentifier()
     * @uses OTA_AirBookRQ::setSequenceNmbr()
     * @uses OTA_AirBookRQ::setTransactionStatusCode()
     * @uses OTA_AirBookRQ::setRetransmissionIndicator()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\AirItineraryType $airItinerary
     * @param \StructType\PriceInfo $priceInfo
     * @param \StructType\TravelerInfoType $travelerInfo
     * @param \StructType\Fulfillment $fulfillment
     * @param \StructType\TicketingInfoType $ticketing
     * @param \StructType\Queue[] $queue
     * @param \StructType\UniqueID_Type $bookingReferenceID
     * @param mixed $tPA_Extensions
     * @param \StructType\TravelersFulfillments $travelersFulfillments
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\AirItineraryType $airItinerary = null, \StructType\PriceInfo $priceInfo = null, \StructType\TravelerInfoType $travelerInfo = null, \StructType\Fulfillment $fulfillment = null, \StructType\TicketingInfoType $ticketing = null, array $queue = array(), \StructType\UniqueID_Type $bookingReferenceID = null, $tPA_Extensions = null, \StructType\TravelersFulfillments $travelersFulfillments = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setQueue($queue)
            ->setBookingReferenceID($bookingReferenceID)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTravelersFulfillments($travelersFulfillments)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\OTA_AirBookRQ
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \StructType\AirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \StructType\AirItineraryType $airItinerary
     * @return \StructType\OTA_AirBookRQ
     */
    public function setAirItinerary(\StructType\AirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \StructType\PriceInfo|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \StructType\PriceInfo $priceInfo
     * @return \StructType\OTA_AirBookRQ
     */
    public function setPriceInfo(\StructType\PriceInfo $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \StructType\TravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \StructType\TravelerInfoType $travelerInfo
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTravelerInfo(\StructType\TravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \StructType\Fulfillment|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \StructType\Fulfillment $fulfillment
     * @return \StructType\OTA_AirBookRQ
     */
    public function setFulfillment(\StructType\Fulfillment $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \StructType\TicketingInfoType|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @param \StructType\TicketingInfoType $ticketing
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTicketing(\StructType\TicketingInfoType $ticketing = null)
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Get Queue value
     * @return \StructType\Queue[]|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue[] $queue
     * @return \StructType\OTA_AirBookRQ
     */
    public function setQueue(array $queue = array())
    {
        foreach ($queue as $oTA_AirBookRQQueueItem) {
            // validation for constraint: itemType
            if (!$oTA_AirBookRQQueueItem instanceof \StructType\Queue) {
                throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \StructType\Queue, "%s" given', is_object($oTA_AirBookRQQueueItem) ? get_class($oTA_AirBookRQQueueItem) : gettype($oTA_AirBookRQQueueItem)), __LINE__);
            }
        }
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Add item to Queue value
     * @throws \InvalidArgumentException
     * @param \StructType\Queue $item
     * @return \StructType\OTA_AirBookRQ
     */
    public function addToQueue(\StructType\Queue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Queue) {
            throw new \InvalidArgumentException(sprintf('The Queue property can only contain items of \StructType\Queue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Queue[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \StructType\UniqueID_Type $bookingReferenceID
     * @return \StructType\OTA_AirBookRQ
     */
    public function setBookingReferenceID(\StructType\UniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TravelersFulfillments value
     * @return \StructType\TravelersFulfillments|null
     */
    public function getTravelersFulfillments()
    {
        return $this->TravelersFulfillments;
    }
    /**
     * Set TravelersFulfillments value
     * @param \StructType\TravelersFulfillments $travelersFulfillments
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTravelersFulfillments(\StructType\TravelersFulfillments $travelersFulfillments = null)
    {
        $this->TravelersFulfillments = $travelersFulfillments;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirBookRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirBookRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirBookRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirBookRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirBookRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirBookRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
