<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirAvailRS StructType
 * Meta informations extracted from the WSDL
 * - documentation: The Availability Response message contains Flight Availability for a city pair on a specific date. A set of OriginDestinationOptions is returned, each of which contains one or more (connecting) flights that serve the city pair. For
 * each flight the following information is returned:- Origin and destination airports- Departure and arrival date/times- Booking Class availability- Equipment- Meal Information- Codeshare information.This message contains similar information to a
 * standard airline CRS or GDS availability response message.
 * @subpackage Structs
 */
class OTA_AirAvailRS extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - documentation: Standard way to indicate successful processing of an OTA message. Returning an empty element of this type indicates success.
     * @var \StructType\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - documentation: Standard way to indicate successful processing of an OTA message, but one in which warnings are generated.
     * - minOccurs: 0
     * @var \StructType\WarningsType
     */
    public $Warnings;
    /**
     * The OriginDestinationOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OriginDestinationOptions
     */
    public $OriginDestinationOptions;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\OriginDestinationInformation[]
     */
    public $OriginDestinationInformation;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Information that may apply to the entire response, such as marketing or header information.
     * - minOccurs: 0
     * @var \StructType\FreeTextType
     */
    public $Comment;
    /**
     * The AAAirAvailRSExt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AAAirAvailRSExt
     */
    public $AAAirAvailRSExt;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - documentation: A collection of errors that occurred during the processing of a message.
     * @var \StructType\ErrorsType
     */
    public $Errors;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var float
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirAvailRS
     * @uses OTA_AirAvailRS::setSuccess()
     * @uses OTA_AirAvailRS::setWarnings()
     * @uses OTA_AirAvailRS::setOriginDestinationOptions()
     * @uses OTA_AirAvailRS::setOriginDestinationInformation()
     * @uses OTA_AirAvailRS::setComment()
     * @uses OTA_AirAvailRS::setAAAirAvailRSExt()
     * @uses OTA_AirAvailRS::setErrors()
     * @uses OTA_AirAvailRS::setEchoToken()
     * @uses OTA_AirAvailRS::setTimeStamp()
     * @uses OTA_AirAvailRS::setTarget()
     * @uses OTA_AirAvailRS::setVersion()
     * @uses OTA_AirAvailRS::setTransactionIdentifier()
     * @uses OTA_AirAvailRS::setSequenceNmbr()
     * @uses OTA_AirAvailRS::setTransactionStatusCode()
     * @uses OTA_AirAvailRS::setRetransmissionIndicator()
     * @param \StructType\SuccessType $success
     * @param \StructType\WarningsType $warnings
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     * @param \StructType\OriginDestinationInformation[] $originDestinationInformation
     * @param \StructType\FreeTextType $comment
     * @param \StructType\AAAirAvailRSExt $aAAirAvailRSExt
     * @param \StructType\ErrorsType $errors
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param float $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct(\StructType\SuccessType $success = null, \StructType\WarningsType $warnings = null, \StructType\OriginDestinationOptions $originDestinationOptions = null, array $originDestinationInformation = array(), \StructType\FreeTextType $comment = null, \StructType\AAAirAvailRSExt $aAAirAvailRSExt = null, \StructType\ErrorsType $errors = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setOriginDestinationOptions($originDestinationOptions)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setComment($comment)
            ->setAAAirAvailRSExt($aAAirAvailRSExt)
            ->setErrors($errors)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get Success value
     * @return \StructType\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\SuccessType $success
     * @return \StructType\OTA_AirAvailRS
     */
    public function setSuccess(\StructType\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\WarningsType $warnings
     * @return \StructType\OTA_AirAvailRS
     */
    public function setWarnings(\StructType\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get OriginDestinationOptions value
     * @return \StructType\OriginDestinationOptions|null
     */
    public function getOriginDestinationOptions()
    {
        return $this->OriginDestinationOptions;
    }
    /**
     * Set OriginDestinationOptions value
     * @param \StructType\OriginDestinationOptions $originDestinationOptions
     * @return \StructType\OTA_AirAvailRS
     */
    public function setOriginDestinationOptions(\StructType\OriginDestinationOptions $originDestinationOptions = null)
    {
        $this->OriginDestinationOptions = $originDestinationOptions;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \StructType\OriginDestinationInformation[]|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestinationInformation[] $originDestinationInformation
     * @return \StructType\OTA_AirAvailRS
     */
    public function setOriginDestinationInformation(array $originDestinationInformation = array())
    {
        foreach ($originDestinationInformation as $oTA_AirAvailRSOriginDestinationInformationItem) {
            // validation for constraint: itemType
            if (!$oTA_AirAvailRSOriginDestinationInformationItem instanceof \StructType\OriginDestinationInformation) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \StructType\OriginDestinationInformation, "%s" given', is_object($oTA_AirAvailRSOriginDestinationInformationItem) ? get_class($oTA_AirAvailRSOriginDestinationInformationItem) : gettype($oTA_AirAvailRSOriginDestinationInformationItem)), __LINE__);
            }
        }
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Add item to OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestinationInformation $item
     * @return \StructType\OTA_AirAvailRS
     */
    public function addToOriginDestinationInformation(\StructType\OriginDestinationInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginDestinationInformation) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \StructType\OriginDestinationInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationInformation[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \StructType\FreeTextType $comment
     * @return \StructType\OTA_AirAvailRS
     */
    public function setComment(\StructType\FreeTextType $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get AAAirAvailRSExt value
     * @return \StructType\AAAirAvailRSExt|null
     */
    public function getAAAirAvailRSExt()
    {
        return $this->AAAirAvailRSExt;
    }
    /**
     * Set AAAirAvailRSExt value
     * @param \StructType\AAAirAvailRSExt $aAAirAvailRSExt
     * @return \StructType\OTA_AirAvailRS
     */
    public function setAAAirAvailRSExt(\StructType\AAAirAvailRSExt $aAAirAvailRSExt = null)
    {
        $this->AAAirAvailRSExt = $aAAirAvailRSExt;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\ErrorsType $errors
     * @return \StructType\OTA_AirAvailRS
     */
    public function setErrors(\StructType\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_AirAvailRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_AirAvailRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_AirAvailRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return float|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \StructType\OTA_AirAvailRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_AirAvailRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \StructType\OTA_AirAvailRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_AirAvailRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \StructType\OTA_AirAvailRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_AirAvailRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
