<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealRequests StructType
 * Meta informations extracted from the WSDL
 * - documentation: A collection of Meal Request
 * @subpackage Structs
 */
class MealRequests extends AbstractStructBase
{
    /**
     * The MealRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MealRequest[]
     */
    public $MealRequest;
    /**
     * Constructor method for MealRequests
     * @uses MealRequests::setMealRequest()
     * @param \StructType\MealRequest[] $mealRequest
     */
    public function __construct(array $mealRequest = array())
    {
        $this
            ->setMealRequest($mealRequest);
    }
    /**
     * Get MealRequest value
     * @return \StructType\MealRequest[]|null
     */
    public function getMealRequest()
    {
        return $this->MealRequest;
    }
    /**
     * Set MealRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MealRequest[] $mealRequest
     * @return \StructType\MealRequests
     */
    public function setMealRequest(array $mealRequest = array())
    {
        foreach ($mealRequest as $mealRequestsMealRequestItem) {
            // validation for constraint: itemType
            if (!$mealRequestsMealRequestItem instanceof \StructType\MealRequest) {
                throw new \InvalidArgumentException(sprintf('The MealRequest property can only contain items of \StructType\MealRequest, "%s" given', is_object($mealRequestsMealRequestItem) ? get_class($mealRequestsMealRequestItem) : gettype($mealRequestsMealRequestItem)), __LINE__);
            }
        }
        $this->MealRequest = $mealRequest;
        return $this;
    }
    /**
     * Add item to MealRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\MealRequest $item
     * @return \StructType\MealRequests
     */
    public function addToMealRequest(\StructType\MealRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MealRequest) {
            throw new \InvalidArgumentException(sprintf('The MealRequest property can only contain items of \StructType\MealRequest, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealRequest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealRequests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
