<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealDetailsResponses StructType
 * Meta informations extracted from the WSDL
 * - documentation: Meal details response element containing the results of the request
 * @subpackage Structs
 */
class MealDetailsResponses extends AbstractStructBase
{
    /**
     * The multipleMealSelectionEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $multipleMealSelectionEnabled;
    /**
     * The MealDetailsResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\MealDetailsResponse[]
     */
    public $MealDetailsResponse;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirTravelers
     */
    public $AirTravelers;
    /**
     * Constructor method for MealDetailsResponses
     * @uses MealDetailsResponses::setMultipleMealSelectionEnabled()
     * @uses MealDetailsResponses::setMealDetailsResponse()
     * @uses MealDetailsResponses::setAirTravelers()
     * @param bool $multipleMealSelectionEnabled
     * @param \StructType\MealDetailsResponse[] $mealDetailsResponse
     * @param \StructType\AirTravelers $airTravelers
     */
    public function __construct($multipleMealSelectionEnabled = null, array $mealDetailsResponse = array(), \StructType\AirTravelers $airTravelers = null)
    {
        $this
            ->setMultipleMealSelectionEnabled($multipleMealSelectionEnabled)
            ->setMealDetailsResponse($mealDetailsResponse)
            ->setAirTravelers($airTravelers);
    }
    /**
     * Get multipleMealSelectionEnabled value
     * @return bool
     */
    public function getMultipleMealSelectionEnabled()
    {
        return $this->multipleMealSelectionEnabled;
    }
    /**
     * Set multipleMealSelectionEnabled value
     * @param bool $multipleMealSelectionEnabled
     * @return \StructType\MealDetailsResponses
     */
    public function setMultipleMealSelectionEnabled($multipleMealSelectionEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($multipleMealSelectionEnabled) && !is_bool($multipleMealSelectionEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multipleMealSelectionEnabled)), __LINE__);
        }
        $this->multipleMealSelectionEnabled = $multipleMealSelectionEnabled;
        return $this;
    }
    /**
     * Get MealDetailsResponse value
     * @return \StructType\MealDetailsResponse[]|null
     */
    public function getMealDetailsResponse()
    {
        return $this->MealDetailsResponse;
    }
    /**
     * Set MealDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\MealDetailsResponse[] $mealDetailsResponse
     * @return \StructType\MealDetailsResponses
     */
    public function setMealDetailsResponse(array $mealDetailsResponse = array())
    {
        foreach ($mealDetailsResponse as $mealDetailsResponsesMealDetailsResponseItem) {
            // validation for constraint: itemType
            if (!$mealDetailsResponsesMealDetailsResponseItem instanceof \StructType\MealDetailsResponse) {
                throw new \InvalidArgumentException(sprintf('The MealDetailsResponse property can only contain items of \StructType\MealDetailsResponse, "%s" given', is_object($mealDetailsResponsesMealDetailsResponseItem) ? get_class($mealDetailsResponsesMealDetailsResponseItem) : gettype($mealDetailsResponsesMealDetailsResponseItem)), __LINE__);
            }
        }
        $this->MealDetailsResponse = $mealDetailsResponse;
        return $this;
    }
    /**
     * Add item to MealDetailsResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\MealDetailsResponse $item
     * @return \StructType\MealDetailsResponses
     */
    public function addToMealDetailsResponse(\StructType\MealDetailsResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MealDetailsResponse) {
            throw new \InvalidArgumentException(sprintf('The MealDetailsResponse property can only contain items of \StructType\MealDetailsResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealDetailsResponse[] = $item;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \StructType\AirTravelers|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \StructType\AirTravelers $airTravelers
     * @return \StructType\MealDetailsResponses
     */
    public function setAirTravelers(\StructType\AirTravelers $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealDetailsResponses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
