<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealDetailsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: One MealDetailsResponse element is returned for each of the flight segment requested in the input request.
 * @subpackage Structs
 */
class MealDetailsResponse extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * @var \StructType\FlightSegmentInfo
     */
    public $FlightSegmentInfo;
    /**
     * The Meal
     * Meta informations extracted from the WSDL
     * - documentation: This identifies the meal details for the flight segment in the corresponding 'FlightSegmentInfo' element.
     * - maxOccurs: 99
     * @var \StructType\Meal[]
     */
    public $Meal;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - documentation: This is used for PNR record locator. If there are more than one PNR numbers because of muliple airlines in the itinerary then this element could be repeated.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * Constructor method for MealDetailsResponse
     * @uses MealDetailsResponse::setFlightSegmentInfo()
     * @uses MealDetailsResponse::setMeal()
     * @uses MealDetailsResponse::setBookingReferenceID()
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @param \StructType\Meal[] $meal
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     */
    public function __construct(\StructType\FlightSegmentInfo $flightSegmentInfo = null, array $meal = array(), array $bookingReferenceID = array())
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setMeal($meal)
            ->setBookingReferenceID($bookingReferenceID);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \StructType\FlightSegmentInfo|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \StructType\FlightSegmentInfo $flightSegmentInfo
     * @return \StructType\MealDetailsResponse
     */
    public function setFlightSegmentInfo(\StructType\FlightSegmentInfo $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get Meal value
     * @return \StructType\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \StructType\Meal[] $meal
     * @return \StructType\MealDetailsResponse
     */
    public function setMeal(array $meal = array())
    {
        foreach ($meal as $mealDetailsResponseMealItem) {
            // validation for constraint: itemType
            if (!$mealDetailsResponseMealItem instanceof \StructType\Meal) {
                throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of \StructType\Meal, "%s" given', is_object($mealDetailsResponseMealItem) ? get_class($mealDetailsResponseMealItem) : gettype($mealDetailsResponseMealItem)), __LINE__);
            }
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \StructType\Meal $item
     * @return \StructType\MealDetailsResponse
     */
    public function addToMeal(\StructType\Meal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meal) {
            throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of \StructType\Meal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $bookingReferenceID
     * @return \StructType\MealDetailsResponse
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $mealDetailsResponseBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$mealDetailsResponseBookingReferenceIDItem instanceof \StructType\UniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($mealDetailsResponseBookingReferenceIDItem) ? get_class($mealDetailsResponseBookingReferenceIDItem) : gettype($mealDetailsResponseBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\MealDetailsResponse
     */
    public function addToBookingReferenceID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \StructType\UniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealDetailsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
