<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealDetailsRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: The number of flight segments for which the meal details are requested for. If an itinerary consists of multiple flight segments then corresponding number of MealDetailsRequest elements will be sent in the request. If there is a
 * gauge change (equipment change) within a flight segment an error response is expected. In such a case two different mealDetailsRequest elements need to be sent requesting meal details for two flight segments for different gauges.
 * @subpackage Structs
 */
class MealDetailsRequest extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * Meta informations extracted from the WSDL
     * - documentation: Flight segment information of the flight segment for which meal information is requested.
     * @var \StructType\FlightSegmentType
     */
    public $FlightSegmentInfo;
    /**
     * The MealDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealDetails
     */
    public $MealDetails;
    /**
     * The TravelerRefNumberRPHs
     * Meta informations extracted from the WSDL
     * - documentation: Reference to one or more travelers for whom meal details requested for this flight segment. RPH Value from TravelerRefNumber of AirTravelerType element will be mapped here. | (Reference Place Holder) - an index code to identify an
     * instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $TravelerRefNumberRPHs;
    /**
     * Constructor method for MealDetailsRequest
     * @uses MealDetailsRequest::setFlightSegmentInfo()
     * @uses MealDetailsRequest::setMealDetails()
     * @uses MealDetailsRequest::setTravelerRefNumberRPHs()
     * @param \StructType\FlightSegmentType $flightSegmentInfo
     * @param \StructType\MealDetails $mealDetails
     * @param string $travelerRefNumberRPHs
     */
    public function __construct(\StructType\FlightSegmentType $flightSegmentInfo = null, \StructType\MealDetails $mealDetails = null, $travelerRefNumberRPHs = null)
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setMealDetails($mealDetails)
            ->setTravelerRefNumberRPHs($travelerRefNumberRPHs);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \StructType\FlightSegmentType|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \StructType\FlightSegmentType $flightSegmentInfo
     * @return \StructType\MealDetailsRequest
     */
    public function setFlightSegmentInfo(\StructType\FlightSegmentType $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get MealDetails value
     * @return \StructType\MealDetails|null
     */
    public function getMealDetails()
    {
        return $this->MealDetails;
    }
    /**
     * Set MealDetails value
     * @param \StructType\MealDetails $mealDetails
     * @return \StructType\MealDetailsRequest
     */
    public function setMealDetails(\StructType\MealDetails $mealDetails = null)
    {
        $this->MealDetails = $mealDetails;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHs value
     * @return string|null
     */
    public function getTravelerRefNumberRPHs()
    {
        return $this->TravelerRefNumberRPHs;
    }
    /**
     * Set TravelerRefNumberRPHs value
     * @param string $travelerRefNumberRPHs
     * @return \StructType\MealDetailsRequest
     */
    public function setTravelerRefNumberRPHs($travelerRefNumberRPHs = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRefNumberRPHs) && !is_string($travelerRefNumberRPHs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelerRefNumberRPHs)), __LINE__);
        }
        $this->TravelerRefNumberRPHs = $travelerRefNumberRPHs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MealDetailsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
