<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Meal StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identifies any meal and/or beverage services that are provided.
 * @subpackage Structs
 */
class Meal extends AbstractStructBase
{
    /**
     * The MealCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to designate a meal or beverage service.
     * - use: required
     * @var string
     */
    public $MealCode;
    /**
     * The mealCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $mealCode;
    /**
     * The mealDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $mealDescription;
    /**
     * The mealCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var float
     */
    public $mealCharge;
    /**
     * The mealName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $mealName;
    /**
     * The availableMeals
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $availableMeals;
    /**
     * The soldMeals
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $soldMeals;
    /**
     * The allocatedMeals
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $allocatedMeals;
    /**
     * The mealImageLink
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $mealImageLink;
    /**
     * The mealCategoryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $mealCategoryCode;
    /**
     * Constructor method for Meal
     * @uses Meal::setMealCode()
     * @uses Meal::setMealCode_1()
     * @uses Meal::setMealDescription()
     * @uses Meal::setMealCharge()
     * @uses Meal::setMealName()
     * @uses Meal::setAvailableMeals()
     * @uses Meal::setSoldMeals()
     * @uses Meal::setAllocatedMeals()
     * @uses Meal::setMealImageLink()
     * @uses Meal::setMealCategoryCode()
     * @param string $mealCode
     * @param string $mealCode
     * @param string $mealDescription
     * @param float $mealCharge
     * @param string $mealName
     * @param int $availableMeals
     * @param int $soldMeals
     * @param int $allocatedMeals
     * @param string $mealImageLink
     * @param string $mealCategoryCode
     */
    public function __construct($mealCode = null, $mealCode = null, $mealDescription = null, $mealCharge = null, $mealName = null, $availableMeals = null, $soldMeals = null, $allocatedMeals = null, $mealImageLink = null, $mealCategoryCode = null)
    {
        $this
            ->setMealCode($mealCode)
            ->setMealCode_1($mealCode)
            ->setMealDescription($mealDescription)
            ->setMealCharge($mealCharge)
            ->setMealName($mealName)
            ->setAvailableMeals($availableMeals)
            ->setSoldMeals($soldMeals)
            ->setAllocatedMeals($allocatedMeals)
            ->setMealImageLink($mealImageLink)
            ->setMealCategoryCode($mealCategoryCode);
    }
    /**
     * Get MealCode value
     * @return string
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @param string $mealCode
     * @return \StructType\Meal
     */
    public function setMealCode($mealCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealCode) && !is_string($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealCode)), __LINE__);
        }
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Get mealCode_1 value
     * @return mealCode_1
     */
    public function getMealCode_1()
    {
        return $this->mealCode;
    }
    /**
     * Set MealCode value
     * @param string $mealCode
     * @return \StructType\Meal
     */
    public function setMealCode_1($mealCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealCode) && !is_string($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealCode)), __LINE__);
        }
        $this->mealCode = $mealCode;
        return $this;
    }
    /**
     * Get mealDescription value
     * @return string
     */
    public function getMealDescription()
    {
        return $this->mealDescription;
    }
    /**
     * Set mealDescription value
     * @param string $mealDescription
     * @return \StructType\Meal
     */
    public function setMealDescription($mealDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mealDescription) && !is_string($mealDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealDescription)), __LINE__);
        }
        $this->mealDescription = $mealDescription;
        return $this;
    }
    /**
     * Get mealCharge value
     * @return float
     */
    public function getMealCharge()
    {
        return $this->mealCharge;
    }
    /**
     * Set mealCharge value
     * @param float $mealCharge
     * @return \StructType\Meal
     */
    public function setMealCharge($mealCharge = null)
    {
        $this->mealCharge = $mealCharge;
        return $this;
    }
    /**
     * Get mealName value
     * @return string
     */
    public function getMealName()
    {
        return $this->mealName;
    }
    /**
     * Set mealName value
     * @param string $mealName
     * @return \StructType\Meal
     */
    public function setMealName($mealName = null)
    {
        // validation for constraint: string
        if (!is_null($mealName) && !is_string($mealName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealName)), __LINE__);
        }
        $this->mealName = $mealName;
        return $this;
    }
    /**
     * Get availableMeals value
     * @return int
     */
    public function getAvailableMeals()
    {
        return $this->availableMeals;
    }
    /**
     * Set availableMeals value
     * @param int $availableMeals
     * @return \StructType\Meal
     */
    public function setAvailableMeals($availableMeals = null)
    {
        // validation for constraint: int
        if (!is_null($availableMeals) && !is_numeric($availableMeals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableMeals)), __LINE__);
        }
        $this->availableMeals = $availableMeals;
        return $this;
    }
    /**
     * Get soldMeals value
     * @return int
     */
    public function getSoldMeals()
    {
        return $this->soldMeals;
    }
    /**
     * Set soldMeals value
     * @param int $soldMeals
     * @return \StructType\Meal
     */
    public function setSoldMeals($soldMeals = null)
    {
        // validation for constraint: int
        if (!is_null($soldMeals) && !is_numeric($soldMeals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($soldMeals)), __LINE__);
        }
        $this->soldMeals = $soldMeals;
        return $this;
    }
    /**
     * Get allocatedMeals value
     * @return int
     */
    public function getAllocatedMeals()
    {
        return $this->allocatedMeals;
    }
    /**
     * Set allocatedMeals value
     * @param int $allocatedMeals
     * @return \StructType\Meal
     */
    public function setAllocatedMeals($allocatedMeals = null)
    {
        // validation for constraint: int
        if (!is_null($allocatedMeals) && !is_numeric($allocatedMeals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allocatedMeals)), __LINE__);
        }
        $this->allocatedMeals = $allocatedMeals;
        return $this;
    }
    /**
     * Get mealImageLink value
     * @return string
     */
    public function getMealImageLink()
    {
        return $this->mealImageLink;
    }
    /**
     * Set mealImageLink value
     * @param string $mealImageLink
     * @return \StructType\Meal
     */
    public function setMealImageLink($mealImageLink = null)
    {
        // validation for constraint: string
        if (!is_null($mealImageLink) && !is_string($mealImageLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealImageLink)), __LINE__);
        }
        $this->mealImageLink = $mealImageLink;
        return $this;
    }
    /**
     * Get mealCategoryCode value
     * @return string
     */
    public function getMealCategoryCode()
    {
        return $this->mealCategoryCode;
    }
    /**
     * Set mealCategoryCode value
     * @param string $mealCategoryCode
     * @return \StructType\Meal
     */
    public function setMealCategoryCode($mealCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($mealCategoryCode) && !is_string($mealCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mealCategoryCode)), __LINE__);
        }
        $this->mealCategoryCode = $mealCategoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Meal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
