<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object to hold an insurance request
 * @subpackage Structs
 */
class InsuranceRequestType extends AbstractStructBase
{
    /**
     * The PolicyCode
     * Meta informations extracted from the WSDL
     * - documentation: Insurance Policy Code
     * - use: optional
     * @var string
     */
    public $PolicyCode;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: The departure date of the journey
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - documentation: The arrival date of the journey
     * - use: optional
     * @var string
     */
    public $ArrivalDate;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - documentation: The origin of the journey
     * - use: optional
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - documentation: The destination of the journey
     * - use: optional
     * @var string
     */
    public $Destination;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: The state of the insurance
     * - use: optional
     * @var string
     */
    public $State;
    /**
     * Constructor method for InsuranceRequestType
     * @uses InsuranceRequestType::setPolicyCode()
     * @uses InsuranceRequestType::setDepartureDate()
     * @uses InsuranceRequestType::setArrivalDate()
     * @uses InsuranceRequestType::setOrigin()
     * @uses InsuranceRequestType::setDestination()
     * @uses InsuranceRequestType::setState()
     * @param string $policyCode
     * @param string $departureDate
     * @param string $arrivalDate
     * @param string $origin
     * @param string $destination
     * @param string $state
     */
    public function __construct($policyCode = null, $departureDate = null, $arrivalDate = null, $origin = null, $destination = null, $state = null)
    {
        $this
            ->setPolicyCode($policyCode)
            ->setDepartureDate($departureDate)
            ->setArrivalDate($arrivalDate)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setState($state);
    }
    /**
     * Get PolicyCode value
     * @return string|null
     */
    public function getPolicyCode()
    {
        return $this->PolicyCode;
    }
    /**
     * Set PolicyCode value
     * @param string $policyCode
     * @return \StructType\InsuranceRequestType
     */
    public function setPolicyCode($policyCode = null)
    {
        // validation for constraint: string
        if (!is_null($policyCode) && !is_string($policyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($policyCode)), __LINE__);
        }
        $this->PolicyCode = $policyCode;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\InsuranceRequestType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\InsuranceRequestType
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\InsuranceRequestType
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\InsuranceRequestType
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\InsuranceRequestType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuranceRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
