<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Details of the flight option for an origin destination pair. | Flight segment information returned for an availability request including ancillary information. | Specifies if the flight is smoking or not. | Details of the flight
 * option for an origin destination pair. | Flight segment information returned for an availability request including ancillary information. | Specifies if the flight is smoking or not. | A collection of one or more legs that are defined as a single
 * flight number. | Specifies if the flight is smoking or not.
 * @subpackage Structs
 */
class FlightSegment extends FlightSegmentType
{
    /**
     * The ScheduleValidStartDate
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the start date for the scheduled flight.
     * - use: required
     * @var string
     */
    public $ScheduleValidStartDate;
    /**
     * The ScheduleValidEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the end date for the scheduled flight.
     * - use: required
     * @var string
     */
    public $ScheduleValidEndDate;
    /**
     * The TrafficRestrictionInfo
     * Meta informations extracted from the WSDL
     * - documentation: Traffic restriction information for a specific flight. | Traffic restriction information for a specific flight.
     * - minOccurs: 0
     * @var \StructType\FreeTextType
     */
    public $TrafficRestrictionInfo;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Any special comments on the leg. eg. operated by XX. | Any special comments on the leg. eg. operated by XX. | Any special comments on the leg. eg. operated by XX.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The MarketingCabin
     * Meta informations extracted from the WSDL
     * - documentation: The airline specific branding for cabins. | The airline specific branding for cabins. | Identifies the marketing name for the cabin. This is the supplier cabin identifier as opposed to the generic industry term for the cabin.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\MarketingCabinType[]
     */
    public $MarketingCabin;
    /**
     * The BookingClassAvail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\BookingClassAvail[]
     */
    public $BookingClassAvail;
    /**
     * The JourneyDuration
     * Meta informations extracted from the WSDL
     * - documentation: The duration of the flight from departure location to destination location. | The duration of the flight from departure location to destination location. | The duration of the flight from departure location to destination location.
     * - use: optional
     * @var string
     */
    public $JourneyDuration;
    /**
     * The OnTimeRate
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the Dept. of Transport on time rate of the flight. | Specifies the Dept. of Transport on time rate of the flight. | Specifies the Dept. of Transport on time rate of the flight. | Used for percentage values
     * - use: optional
     * - maxInclusive: 100.00
     * - minInclusive: 0.01
     * @var float
     */
    public $OnTimeRate;
    /**
     * The Ticket
     * Meta informations extracted from the WSDL
     * - default: Paper
     * - documentation: Specifies if the flight is e-ticketable or not. | Specifies if the flight is e-ticketable or not.
     * @var string
     */
    public $Ticket;
    /**
     * The ParticipationLevelCode
     * Meta informations extracted from the WSDL
     * - documentation: To specify the level of participation by a vendor in another system. Refer to OTA Code List 'Participation Level Code' (PLC). | To specify the level of participation by a vendor in another system. Refer to OTA Code List
     * 'Participation Level Code' (PLC). | Used for codes in the OTA code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - use: optional
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * The GroundDuration
     * Meta informations extracted from the WSDL
     * - documentation: The duration of a ground stop. | The duration of a ground stop.
     * - use: optional
     * @var string
     */
    public $GroundDuration;
    /**
     * The AccumulatedDuration
     * Meta informations extracted from the WSDL
     * - documentation: The total duration time of the flight. This is the combination of both JourneyDuration and GroundDuration. | The total duration time of the flight. This is the combination of both JourneyDuration and GroundDuration.
     * - use: optional
     * @var string
     */
    public $AccumulatedDuration;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - documentation: Miles acquired per flight segment, usually used for earning of frequent flyer miles. | Miles acquired per flight segment, usually used for earning of frequent flyer miles.
     * - use: optional
     * @var int
     */
    public $Distance;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The DaysOfOperation
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the days of week the flight operates.
     * - minOccurs: 0
     * @var \StructType\OperationSchedulesType
     */
    public $DaysOfOperation;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setScheduleValidStartDate()
     * @uses FlightSegment::setScheduleValidEndDate()
     * @uses FlightSegment::setTrafficRestrictionInfo()
     * @uses FlightSegment::setComment()
     * @uses FlightSegment::setMarketingCabin()
     * @uses FlightSegment::setBookingClassAvail()
     * @uses FlightSegment::setJourneyDuration()
     * @uses FlightSegment::setOnTimeRate()
     * @uses FlightSegment::setTicket()
     * @uses FlightSegment::setParticipationLevelCode()
     * @uses FlightSegment::setGroundDuration()
     * @uses FlightSegment::setAccumulatedDuration()
     * @uses FlightSegment::setDistance()
     * @uses FlightSegment::setSmokingAllowed()
     * @uses FlightSegment::setDaysOfOperation()
     * @param string $scheduleValidStartDate
     * @param string $scheduleValidEndDate
     * @param \StructType\FreeTextType $trafficRestrictionInfo
     * @param \StructType\FreeTextType[] $comment
     * @param \StructType\MarketingCabinType[] $marketingCabin
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     * @param string $journeyDuration
     * @param float $onTimeRate
     * @param string $ticket
     * @param string $participationLevelCode
     * @param string $groundDuration
     * @param string $accumulatedDuration
     * @param int $distance
     * @param bool $smokingAllowed
     * @param \StructType\OperationSchedulesType $daysOfOperation
     */
    public function __construct($scheduleValidStartDate = null, $scheduleValidEndDate = null, \StructType\FreeTextType $trafficRestrictionInfo = null, array $comment = array(), array $marketingCabin = array(), array $bookingClassAvail = array(), $journeyDuration = null, $onTimeRate = null, $ticket = 'Paper', $participationLevelCode = null, $groundDuration = null, $accumulatedDuration = null, $distance = null, $smokingAllowed = null, \StructType\OperationSchedulesType $daysOfOperation = null)
    {
        $this
            ->setScheduleValidStartDate($scheduleValidStartDate)
            ->setScheduleValidEndDate($scheduleValidEndDate)
            ->setTrafficRestrictionInfo($trafficRestrictionInfo)
            ->setComment($comment)
            ->setMarketingCabin($marketingCabin)
            ->setBookingClassAvail($bookingClassAvail)
            ->setJourneyDuration($journeyDuration)
            ->setOnTimeRate($onTimeRate)
            ->setTicket($ticket)
            ->setParticipationLevelCode($participationLevelCode)
            ->setGroundDuration($groundDuration)
            ->setAccumulatedDuration($accumulatedDuration)
            ->setDistance($distance)
            ->setSmokingAllowed($smokingAllowed)
            ->setDaysOfOperation($daysOfOperation);
    }
    /**
     * Get ScheduleValidStartDate value
     * @return string
     */
    public function getScheduleValidStartDate()
    {
        return $this->ScheduleValidStartDate;
    }
    /**
     * Set ScheduleValidStartDate value
     * @param string $scheduleValidStartDate
     * @return \StructType\FlightSegment
     */
    public function setScheduleValidStartDate($scheduleValidStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleValidStartDate) && !is_string($scheduleValidStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduleValidStartDate)), __LINE__);
        }
        $this->ScheduleValidStartDate = $scheduleValidStartDate;
        return $this;
    }
    /**
     * Get ScheduleValidEndDate value
     * @return string
     */
    public function getScheduleValidEndDate()
    {
        return $this->ScheduleValidEndDate;
    }
    /**
     * Set ScheduleValidEndDate value
     * @param string $scheduleValidEndDate
     * @return \StructType\FlightSegment
     */
    public function setScheduleValidEndDate($scheduleValidEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleValidEndDate) && !is_string($scheduleValidEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduleValidEndDate)), __LINE__);
        }
        $this->ScheduleValidEndDate = $scheduleValidEndDate;
        return $this;
    }
    /**
     * Get TrafficRestrictionInfo value
     * @return \StructType\FreeTextType|null
     */
    public function getTrafficRestrictionInfo()
    {
        return $this->TrafficRestrictionInfo;
    }
    /**
     * Set TrafficRestrictionInfo value
     * @param \StructType\FreeTextType $trafficRestrictionInfo
     * @return \StructType\FlightSegment
     */
    public function setTrafficRestrictionInfo(\StructType\FreeTextType $trafficRestrictionInfo = null)
    {
        $this->TrafficRestrictionInfo = $trafficRestrictionInfo;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\FlightSegment
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $flightSegmentCommentItem) {
            // validation for constraint: itemType
            if (!$flightSegmentCommentItem instanceof \StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($flightSegmentCommentItem) ? get_class($flightSegmentCommentItem) : gettype($flightSegmentCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\FlightSegment
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get MarketingCabin value
     * @return \StructType\MarketingCabinType[]|null
     */
    public function getMarketingCabin()
    {
        return $this->MarketingCabin;
    }
    /**
     * Set MarketingCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingCabinType[] $marketingCabin
     * @return \StructType\FlightSegment
     */
    public function setMarketingCabin(array $marketingCabin = array())
    {
        foreach ($marketingCabin as $flightSegmentMarketingCabinItem) {
            // validation for constraint: itemType
            if (!$flightSegmentMarketingCabinItem instanceof \StructType\MarketingCabinType) {
                throw new \InvalidArgumentException(sprintf('The MarketingCabin property can only contain items of \StructType\MarketingCabinType, "%s" given', is_object($flightSegmentMarketingCabinItem) ? get_class($flightSegmentMarketingCabinItem) : gettype($flightSegmentMarketingCabinItem)), __LINE__);
            }
        }
        $this->MarketingCabin = $marketingCabin;
        return $this;
    }
    /**
     * Add item to MarketingCabin value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingCabinType $item
     * @return \StructType\FlightSegment
     */
    public function addToMarketingCabin(\StructType\MarketingCabinType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingCabinType) {
            throw new \InvalidArgumentException(sprintf('The MarketingCabin property can only contain items of \StructType\MarketingCabinType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarketingCabin[] = $item;
        return $this;
    }
    /**
     * Get BookingClassAvail value
     * @return \StructType\BookingClassAvail[]|null
     */
    public function getBookingClassAvail()
    {
        return $this->BookingClassAvail;
    }
    /**
     * Set BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail[] $bookingClassAvail
     * @return \StructType\FlightSegment
     */
    public function setBookingClassAvail(array $bookingClassAvail = array())
    {
        foreach ($bookingClassAvail as $flightSegmentBookingClassAvailItem) {
            // validation for constraint: itemType
            if (!$flightSegmentBookingClassAvailItem instanceof \StructType\BookingClassAvail) {
                throw new \InvalidArgumentException(sprintf('The BookingClassAvail property can only contain items of \StructType\BookingClassAvail, "%s" given', is_object($flightSegmentBookingClassAvailItem) ? get_class($flightSegmentBookingClassAvailItem) : gettype($flightSegmentBookingClassAvailItem)), __LINE__);
            }
        }
        $this->BookingClassAvail = $bookingClassAvail;
        return $this;
    }
    /**
     * Add item to BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvail $item
     * @return \StructType\FlightSegment
     */
    public function addToBookingClassAvail(\StructType\BookingClassAvail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingClassAvail) {
            throw new \InvalidArgumentException(sprintf('The BookingClassAvail property can only contain items of \StructType\BookingClassAvail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingClassAvail[] = $item;
        return $this;
    }
    /**
     * Get JourneyDuration value
     * @return string|null
     */
    public function getJourneyDuration()
    {
        return $this->JourneyDuration;
    }
    /**
     * Set JourneyDuration value
     * @param string $journeyDuration
     * @return \StructType\FlightSegment
     */
    public function setJourneyDuration($journeyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($journeyDuration) && !is_string($journeyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($journeyDuration)), __LINE__);
        }
        $this->JourneyDuration = $journeyDuration;
        return $this;
    }
    /**
     * Get OnTimeRate value
     * @return float|null
     */
    public function getOnTimeRate()
    {
        return $this->OnTimeRate;
    }
    /**
     * Set OnTimeRate value
     * @param float $onTimeRate
     * @return \StructType\FlightSegment
     */
    public function setOnTimeRate($onTimeRate = null)
    {
        // validation for constraint: maxInclusive
        if ($onTimeRate > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 100, "%s" given', $onTimeRate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($onTimeRate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $onTimeRate), __LINE__);
        }
        $this->OnTimeRate = $onTimeRate;
        return $this;
    }
    /**
     * Get Ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticket
     * @return \StructType\FlightSegment
     */
    public function setTicket($ticket = 'Paper')
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($ticket)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ticket, implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \StructType\FlightSegment
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($participationLevelCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}", "%s" given', var_export($participationLevelCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participationLevelCode)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Get GroundDuration value
     * @return string|null
     */
    public function getGroundDuration()
    {
        return $this->GroundDuration;
    }
    /**
     * Set GroundDuration value
     * @param string $groundDuration
     * @return \StructType\FlightSegment
     */
    public function setGroundDuration($groundDuration = null)
    {
        // validation for constraint: string
        if (!is_null($groundDuration) && !is_string($groundDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundDuration)), __LINE__);
        }
        $this->GroundDuration = $groundDuration;
        return $this;
    }
    /**
     * Get AccumulatedDuration value
     * @return string|null
     */
    public function getAccumulatedDuration()
    {
        return $this->AccumulatedDuration;
    }
    /**
     * Set AccumulatedDuration value
     * @param string $accumulatedDuration
     * @return \StructType\FlightSegment
     */
    public function setAccumulatedDuration($accumulatedDuration = null)
    {
        // validation for constraint: string
        if (!is_null($accumulatedDuration) && !is_string($accumulatedDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accumulatedDuration)), __LINE__);
        }
        $this->AccumulatedDuration = $accumulatedDuration;
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\FlightSegment
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !is_numeric($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\FlightSegment
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get DaysOfOperation value
     * @return \StructType\OperationSchedulesType|null
     */
    public function getDaysOfOperation()
    {
        return $this->DaysOfOperation;
    }
    /**
     * Set DaysOfOperation value
     * @param \StructType\OperationSchedulesType $daysOfOperation
     * @return \StructType\FlightSegment
     */
    public function setDaysOfOperation(\StructType\OperationSchedulesType $daysOfOperation = null)
    {
        $this->DaysOfOperation = $daysOfOperation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
