<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information regarding each leg of the flight. A flight leg is one departure and one arrival (non-stop sector).
 * @subpackage Structs
 */
class FlightLegInfo extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * @var \StructType\DepartureAirport
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\ArrivalAirport[]
     */
    public $ArrivalAirport;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The marketing airline.
     * @var \StructType\CompanyNameType
     */
    public $MarketingAirline;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - documentation: The operating airline of the flight if it is a codeshare flight.
     * - minOccurs: 0
     * @var \StructType\OperatingAirlineType
     */
    public $OperatingAirline;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - documentation: The type of equipment used for the flight..
     * - minOccurs: 0
     * @var \StructType\EquipmentType
     */
    public $Equipment;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Comment[]
     */
    public $Comment;
    /**
     * The DepartureDateTime
     * @var \StructType\DepartureDateTime
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * @var \StructType\ArrivalDateTime
     */
    public $ArrivalDateTime;
    /**
     * The OperationTimes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OperationTimes
     */
    public $OperationTimes;
    /**
     * The FlightStatus
     * Meta informations extracted from the WSDL
     * - documentation: Status of the current flight operation. | Used for Character Strings, length 1 to 32
     * - use: optional
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $FlightStatus;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The JourneyDuration
     * @var string
     */
    public $JourneyDuration;
    /**
     * The GroundDuration
     * @var string
     */
    public $GroundDuration;
    /**
     * The AccumulatedDuration
     * @var string
     */
    public $AccumulatedDuration;
    /**
     * The LegDistance
     * @var int
     */
    public $LegDistance;
    /**
     * Constructor method for FlightLegInfo
     * @uses FlightLegInfo::setDepartureAirport()
     * @uses FlightLegInfo::setArrivalAirport()
     * @uses FlightLegInfo::setMarketingAirline()
     * @uses FlightLegInfo::setOperatingAirline()
     * @uses FlightLegInfo::setEquipment()
     * @uses FlightLegInfo::setComment()
     * @uses FlightLegInfo::setDepartureDateTime()
     * @uses FlightLegInfo::setArrivalDateTime()
     * @uses FlightLegInfo::setOperationTimes()
     * @uses FlightLegInfo::setFlightStatus()
     * @uses FlightLegInfo::setFlightNumber()
     * @uses FlightLegInfo::setJourneyDuration()
     * @uses FlightLegInfo::setGroundDuration()
     * @uses FlightLegInfo::setAccumulatedDuration()
     * @uses FlightLegInfo::setLegDistance()
     * @param \StructType\DepartureAirport $departureAirport
     * @param \StructType\ArrivalAirport[] $arrivalAirport
     * @param \StructType\CompanyNameType $marketingAirline
     * @param \StructType\OperatingAirlineType $operatingAirline
     * @param \StructType\EquipmentType $equipment
     * @param \StructType\Comment[] $comment
     * @param \StructType\DepartureDateTime $departureDateTime
     * @param \StructType\ArrivalDateTime $arrivalDateTime
     * @param \StructType\OperationTimes $operationTimes
     * @param string $flightStatus
     * @param string $flightNumber
     * @param string $journeyDuration
     * @param string $groundDuration
     * @param string $accumulatedDuration
     * @param int $legDistance
     */
    public function __construct(\StructType\DepartureAirport $departureAirport = null, array $arrivalAirport = array(), \StructType\CompanyNameType $marketingAirline = null, \StructType\OperatingAirlineType $operatingAirline = null, \StructType\EquipmentType $equipment = null, array $comment = array(), \StructType\DepartureDateTime $departureDateTime = null, \StructType\ArrivalDateTime $arrivalDateTime = null, \StructType\OperationTimes $operationTimes = null, $flightStatus = null, $flightNumber = null, $journeyDuration = null, $groundDuration = null, $accumulatedDuration = null, $legDistance = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setMarketingAirline($marketingAirline)
            ->setOperatingAirline($operatingAirline)
            ->setEquipment($equipment)
            ->setComment($comment)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setOperationTimes($operationTimes)
            ->setFlightStatus($flightStatus)
            ->setFlightNumber($flightNumber)
            ->setJourneyDuration($journeyDuration)
            ->setGroundDuration($groundDuration)
            ->setAccumulatedDuration($accumulatedDuration)
            ->setLegDistance($legDistance);
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\DepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\DepartureAirport $departureAirport
     * @return \StructType\FlightLegInfo
     */
    public function setDepartureAirport(\StructType\DepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \StructType\ArrivalAirport[]|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivalAirport[] $arrivalAirport
     * @return \StructType\FlightLegInfo
     */
    public function setArrivalAirport(array $arrivalAirport = array())
    {
        foreach ($arrivalAirport as $flightLegInfoArrivalAirportItem) {
            // validation for constraint: itemType
            if (!$flightLegInfoArrivalAirportItem instanceof \StructType\ArrivalAirport) {
                throw new \InvalidArgumentException(sprintf('The ArrivalAirport property can only contain items of \StructType\ArrivalAirport, "%s" given', is_object($flightLegInfoArrivalAirportItem) ? get_class($flightLegInfoArrivalAirportItem) : gettype($flightLegInfoArrivalAirportItem)), __LINE__);
            }
        }
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Add item to ArrivalAirport value
     * @throws \InvalidArgumentException
     * @param \StructType\ArrivalAirport $item
     * @return \StructType\FlightLegInfo
     */
    public function addToArrivalAirport(\StructType\ArrivalAirport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArrivalAirport) {
            throw new \InvalidArgumentException(sprintf('The ArrivalAirport property can only contain items of \StructType\ArrivalAirport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrivalAirport[] = $item;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \StructType\CompanyNameType|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \StructType\CompanyNameType $marketingAirline
     * @return \StructType\FlightLegInfo
     */
    public function setMarketingAirline(\StructType\CompanyNameType $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \StructType\OperatingAirlineType|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \StructType\OperatingAirlineType $operatingAirline
     * @return \StructType\FlightLegInfo
     */
    public function setOperatingAirline(\StructType\OperatingAirlineType $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \StructType\EquipmentType|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\EquipmentType $equipment
     * @return \StructType\FlightLegInfo
     */
    public function setEquipment(\StructType\EquipmentType $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\Comment[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment[] $comment
     * @return \StructType\FlightLegInfo
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $flightLegInfoCommentItem) {
            // validation for constraint: itemType
            if (!$flightLegInfoCommentItem instanceof \StructType\Comment) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\Comment, "%s" given', is_object($flightLegInfoCommentItem) ? get_class($flightLegInfoCommentItem) : gettype($flightLegInfoCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment $item
     * @return \StructType\FlightLegInfo
     */
    public function addToComment(\StructType\Comment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comment) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\Comment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return \StructType\DepartureDateTime|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param \StructType\DepartureDateTime $departureDateTime
     * @return \StructType\FlightLegInfo
     */
    public function setDepartureDateTime(\StructType\DepartureDateTime $departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return \StructType\ArrivalDateTime|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param \StructType\ArrivalDateTime $arrivalDateTime
     * @return \StructType\FlightLegInfo
     */
    public function setArrivalDateTime(\StructType\ArrivalDateTime $arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get OperationTimes value
     * @return \StructType\OperationTimes|null
     */
    public function getOperationTimes()
    {
        return $this->OperationTimes;
    }
    /**
     * Set OperationTimes value
     * @param \StructType\OperationTimes $operationTimes
     * @return \StructType\FlightLegInfo
     */
    public function setOperationTimes(\StructType\OperationTimes $operationTimes = null)
    {
        $this->OperationTimes = $operationTimes;
        return $this;
    }
    /**
     * Get FlightStatus value
     * @return string|null
     */
    public function getFlightStatus()
    {
        return $this->FlightStatus;
    }
    /**
     * Set FlightStatus value
     * @param string $flightStatus
     * @return \StructType\FlightLegInfo
     */
    public function setFlightStatus($flightStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($flightStatus) && strlen($flightStatus) > 32) || (is_array($flightStatus) && count($flightStatus) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($flightStatus) ? strlen($flightStatus) : count($flightStatus)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($flightStatus) && strlen($flightStatus) < 1) || (is_array($flightStatus) && count($flightStatus) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($flightStatus) && !is_string($flightStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightStatus)), __LINE__);
        }
        $this->FlightStatus = $flightStatus;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightLegInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get JourneyDuration value
     * @return string|null
     */
    public function getJourneyDuration()
    {
        return $this->JourneyDuration;
    }
    /**
     * Set JourneyDuration value
     * @param string $journeyDuration
     * @return \StructType\FlightLegInfo
     */
    public function setJourneyDuration($journeyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($journeyDuration) && !is_string($journeyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($journeyDuration)), __LINE__);
        }
        $this->JourneyDuration = $journeyDuration;
        return $this;
    }
    /**
     * Get GroundDuration value
     * @return string|null
     */
    public function getGroundDuration()
    {
        return $this->GroundDuration;
    }
    /**
     * Set GroundDuration value
     * @param string $groundDuration
     * @return \StructType\FlightLegInfo
     */
    public function setGroundDuration($groundDuration = null)
    {
        // validation for constraint: string
        if (!is_null($groundDuration) && !is_string($groundDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundDuration)), __LINE__);
        }
        $this->GroundDuration = $groundDuration;
        return $this;
    }
    /**
     * Get AccumulatedDuration value
     * @return string|null
     */
    public function getAccumulatedDuration()
    {
        return $this->AccumulatedDuration;
    }
    /**
     * Set AccumulatedDuration value
     * @param string $accumulatedDuration
     * @return \StructType\FlightLegInfo
     */
    public function setAccumulatedDuration($accumulatedDuration = null)
    {
        // validation for constraint: string
        if (!is_null($accumulatedDuration) && !is_string($accumulatedDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accumulatedDuration)), __LINE__);
        }
        $this->AccumulatedDuration = $accumulatedDuration;
        return $this;
    }
    /**
     * Get LegDistance value
     * @return int|null
     */
    public function getLegDistance()
    {
        return $this->LegDistance;
    }
    /**
     * Set LegDistance value
     * @param int $legDistance
     * @return \StructType\FlightLegInfo
     */
    public function setLegDistance($legDistance = null)
    {
        // validation for constraint: int
        if (!is_null($legDistance) && !is_numeric($legDistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($legDistance)), __LINE__);
        }
        $this->LegDistance = $legDistance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightLegInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
