<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInfoDetails StructType
 * Meta informations extracted from the WSDL
 * - documentation: Collection of flight information for a flight number.
 * @subpackage Structs
 */
class FlightInfoDetails extends AbstractStructBase
{
    /**
     * The FlightLegInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\FlightLegInfo[]
     */
    public $FlightLegInfo;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Any special comments on the flight.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The MessageStatus
     * Meta informations extracted from the WSDL
     * - documentation: Indicates various status information about the flight such as real-time, scheduled or flight cancelled. | Used for Character Strings, length 1 to 32
     * - use: optional
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $MessageStatus;
    /**
     * The TotalFlightTime
     * @var string
     */
    public $TotalFlightTime;
    /**
     * The TotalGroundTime
     * @var string
     */
    public $TotalGroundTime;
    /**
     * The TotalTripTime
     * @var string
     */
    public $TotalTripTime;
    /**
     * The TotalMiles
     * @var int
     */
    public $TotalMiles;
    /**
     * Constructor method for FlightInfoDetails
     * @uses FlightInfoDetails::setFlightLegInfo()
     * @uses FlightInfoDetails::setComment()
     * @uses FlightInfoDetails::setMessageStatus()
     * @uses FlightInfoDetails::setTotalFlightTime()
     * @uses FlightInfoDetails::setTotalGroundTime()
     * @uses FlightInfoDetails::setTotalTripTime()
     * @uses FlightInfoDetails::setTotalMiles()
     * @param \StructType\FlightLegInfo[] $flightLegInfo
     * @param \StructType\FreeTextType[] $comment
     * @param string $messageStatus
     * @param string $totalFlightTime
     * @param string $totalGroundTime
     * @param string $totalTripTime
     * @param int $totalMiles
     */
    public function __construct(array $flightLegInfo = array(), array $comment = array(), $messageStatus = null, $totalFlightTime = null, $totalGroundTime = null, $totalTripTime = null, $totalMiles = null)
    {
        $this
            ->setFlightLegInfo($flightLegInfo)
            ->setComment($comment)
            ->setMessageStatus($messageStatus)
            ->setTotalFlightTime($totalFlightTime)
            ->setTotalGroundTime($totalGroundTime)
            ->setTotalTripTime($totalTripTime)
            ->setTotalMiles($totalMiles);
    }
    /**
     * Get FlightLegInfo value
     * @return \StructType\FlightLegInfo[]|null
     */
    public function getFlightLegInfo()
    {
        return $this->FlightLegInfo;
    }
    /**
     * Set FlightLegInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLegInfo[] $flightLegInfo
     * @return \StructType\FlightInfoDetails
     */
    public function setFlightLegInfo(array $flightLegInfo = array())
    {
        foreach ($flightLegInfo as $flightInfoDetailsFlightLegInfoItem) {
            // validation for constraint: itemType
            if (!$flightInfoDetailsFlightLegInfoItem instanceof \StructType\FlightLegInfo) {
                throw new \InvalidArgumentException(sprintf('The FlightLegInfo property can only contain items of \StructType\FlightLegInfo, "%s" given', is_object($flightInfoDetailsFlightLegInfoItem) ? get_class($flightInfoDetailsFlightLegInfoItem) : gettype($flightInfoDetailsFlightLegInfoItem)), __LINE__);
            }
        }
        $this->FlightLegInfo = $flightLegInfo;
        return $this;
    }
    /**
     * Add item to FlightLegInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLegInfo $item
     * @return \StructType\FlightInfoDetails
     */
    public function addToFlightLegInfo(\StructType\FlightLegInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightLegInfo) {
            throw new \InvalidArgumentException(sprintf('The FlightLegInfo property can only contain items of \StructType\FlightLegInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightLegInfo[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\FlightInfoDetails
     */
    public function setComment(array $comment = array())
    {
        foreach ($comment as $flightInfoDetailsCommentItem) {
            // validation for constraint: itemType
            if (!$flightInfoDetailsCommentItem instanceof \StructType\FreeTextType) {
                throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($flightInfoDetailsCommentItem) ? get_class($flightInfoDetailsCommentItem) : gettype($flightInfoDetailsCommentItem)), __LINE__);
            }
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\FlightInfoDetails
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of \StructType\FreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get MessageStatus value
     * @return string|null
     */
    public function getMessageStatus()
    {
        return $this->MessageStatus;
    }
    /**
     * Set MessageStatus value
     * @param string $messageStatus
     * @return \StructType\FlightInfoDetails
     */
    public function setMessageStatus($messageStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($messageStatus) && strlen($messageStatus) > 32) || (is_array($messageStatus) && count($messageStatus) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($messageStatus) ? strlen($messageStatus) : count($messageStatus)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($messageStatus) && strlen($messageStatus) < 1) || (is_array($messageStatus) && count($messageStatus) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($messageStatus) && !is_string($messageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageStatus)), __LINE__);
        }
        $this->MessageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get TotalFlightTime value
     * @return string|null
     */
    public function getTotalFlightTime()
    {
        return $this->TotalFlightTime;
    }
    /**
     * Set TotalFlightTime value
     * @param string $totalFlightTime
     * @return \StructType\FlightInfoDetails
     */
    public function setTotalFlightTime($totalFlightTime = null)
    {
        // validation for constraint: string
        if (!is_null($totalFlightTime) && !is_string($totalFlightTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalFlightTime)), __LINE__);
        }
        $this->TotalFlightTime = $totalFlightTime;
        return $this;
    }
    /**
     * Get TotalGroundTime value
     * @return string|null
     */
    public function getTotalGroundTime()
    {
        return $this->TotalGroundTime;
    }
    /**
     * Set TotalGroundTime value
     * @param string $totalGroundTime
     * @return \StructType\FlightInfoDetails
     */
    public function setTotalGroundTime($totalGroundTime = null)
    {
        // validation for constraint: string
        if (!is_null($totalGroundTime) && !is_string($totalGroundTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalGroundTime)), __LINE__);
        }
        $this->TotalGroundTime = $totalGroundTime;
        return $this;
    }
    /**
     * Get TotalTripTime value
     * @return string|null
     */
    public function getTotalTripTime()
    {
        return $this->TotalTripTime;
    }
    /**
     * Set TotalTripTime value
     * @param string $totalTripTime
     * @return \StructType\FlightInfoDetails
     */
    public function setTotalTripTime($totalTripTime = null)
    {
        // validation for constraint: string
        if (!is_null($totalTripTime) && !is_string($totalTripTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalTripTime)), __LINE__);
        }
        $this->TotalTripTime = $totalTripTime;
        return $this;
    }
    /**
     * Get TotalMiles value
     * @return int|null
     */
    public function getTotalMiles()
    {
        return $this->TotalMiles;
    }
    /**
     * Set TotalMiles value
     * @param int $totalMiles
     * @return \StructType\FlightInfoDetails
     */
    public function setTotalMiles($totalMiles = null)
    {
        // validation for constraint: int
        if (!is_null($totalMiles) && !is_numeric($totalMiles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalMiles)), __LINE__);
        }
        $this->TotalMiles = $totalMiles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightInfoDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
