<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlexiFareSelectionOptions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The flexibility selection options.
 * @subpackage Structs
 */
class FlexiFareSelectionOptions extends AbstractStructBase
{
    /**
     * The OutBoundFlexiSelected
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether to select out-bound flexi fares.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $OutBoundFlexiSelected;
    /**
     * The InBoundFlexiSelected
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether to select in-bound flexi fares.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $InBoundFlexiSelected;
    /**
     * Constructor method for FlexiFareSelectionOptions
     * @uses FlexiFareSelectionOptions::setOutBoundFlexiSelected()
     * @uses FlexiFareSelectionOptions::setInBoundFlexiSelected()
     * @param bool $outBoundFlexiSelected
     * @param bool $inBoundFlexiSelected
     */
    public function __construct($outBoundFlexiSelected = null, $inBoundFlexiSelected = null)
    {
        $this
            ->setOutBoundFlexiSelected($outBoundFlexiSelected)
            ->setInBoundFlexiSelected($inBoundFlexiSelected);
    }
    /**
     * Get OutBoundFlexiSelected value
     * @return bool|null
     */
    public function getOutBoundFlexiSelected()
    {
        return $this->OutBoundFlexiSelected;
    }
    /**
     * Set OutBoundFlexiSelected value
     * @param bool $outBoundFlexiSelected
     * @return \StructType\FlexiFareSelectionOptions
     */
    public function setOutBoundFlexiSelected($outBoundFlexiSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($outBoundFlexiSelected) && !is_bool($outBoundFlexiSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($outBoundFlexiSelected)), __LINE__);
        }
        $this->OutBoundFlexiSelected = $outBoundFlexiSelected;
        return $this;
    }
    /**
     * Get InBoundFlexiSelected value
     * @return bool|null
     */
    public function getInBoundFlexiSelected()
    {
        return $this->InBoundFlexiSelected;
    }
    /**
     * Set InBoundFlexiSelected value
     * @param bool $inBoundFlexiSelected
     * @return \StructType\FlexiFareSelectionOptions
     */
    public function setInBoundFlexiSelected($inBoundFlexiSelected = null)
    {
        // validation for constraint: boolean
        if (!is_null($inBoundFlexiSelected) && !is_bool($inBoundFlexiSelected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inBoundFlexiSelected)), __LINE__);
        }
        $this->InBoundFlexiSelected = $inBoundFlexiSelected;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlexiFareSelectionOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
