<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Holds a base fare, tax, total and currency information on a price | Used to indicate a negotiated fare and, if so, the fare code. | The type of fare required e.g. unrestricted, excursion etc. Refer to the Fare Qualifier OTA Code list
 * (FAQ).
 * - union: UpperCaseAlphaLength1to3 | OTA_CodeType
 * @subpackage Structs
 */
class FareType extends AbstractStructBase
{
    /**
     * The BaseFare
     * @var \StructType\BaseFare
     */
    public $BaseFare;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EquivFare
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalFare
     */
    public $TotalFare;
    /**
     * The TotalEquivFare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalEquivFare
     */
    public $TotalEquivFare;
    /**
     * The TotalFareWithCCFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalFareWithCCFee
     */
    public $TotalFareWithCCFee;
    /**
     * The TotalEquivFareWithCCFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalEquivFareWithCCFee
     */
    public $TotalEquivFareWithCCFee;
    /**
     * The FareConstruction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareConstruction
     */
    public $FareConstruction;
    /**
     * The UnstructuredFareCalc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UnstructuredFareCalc
     */
    public $UnstructuredFareCalc;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TicketDesignatorCode
     * Meta informations extracted from the WSDL
     * - documentation: Specifies a discount code applicable to the fare.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * Constructor method for FareType
     * @uses FareType::setBaseFare()
     * @uses FareType::setEquivFare()
     * @uses FareType::setTaxes()
     * @uses FareType::setFees()
     * @uses FareType::setTotalFare()
     * @uses FareType::setTotalEquivFare()
     * @uses FareType::setTotalFareWithCCFee()
     * @uses FareType::setTotalEquivFareWithCCFee()
     * @uses FareType::setFareConstruction()
     * @uses FareType::setUnstructuredFareCalc()
     * @uses FareType::setTPA_Extensions()
     * @uses FareType::setTicketDesignatorCode()
     * @param \StructType\BaseFare $baseFare
     * @param \StructType\EquivFare $equivFare
     * @param \StructType\Taxes $taxes
     * @param \StructType\Fees $fees
     * @param \StructType\TotalFare $totalFare
     * @param \StructType\TotalEquivFare $totalEquivFare
     * @param \StructType\TotalFareWithCCFee $totalFareWithCCFee
     * @param \StructType\TotalEquivFareWithCCFee $totalEquivFareWithCCFee
     * @param \StructType\FareConstruction $fareConstruction
     * @param \StructType\UnstructuredFareCalc $unstructuredFareCalc
     * @param mixed $tPA_Extensions
     * @param string $ticketDesignatorCode
     */
    public function __construct(\StructType\BaseFare $baseFare = null, \StructType\EquivFare $equivFare = null, \StructType\Taxes $taxes = null, \StructType\Fees $fees = null, \StructType\TotalFare $totalFare = null, \StructType\TotalEquivFare $totalEquivFare = null, \StructType\TotalFareWithCCFee $totalFareWithCCFee = null, \StructType\TotalEquivFareWithCCFee $totalEquivFareWithCCFee = null, \StructType\FareConstruction $fareConstruction = null, \StructType\UnstructuredFareCalc $unstructuredFareCalc = null, $tPA_Extensions = null, $ticketDesignatorCode = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setTotalFare($totalFare)
            ->setTotalEquivFare($totalEquivFare)
            ->setTotalFareWithCCFee($totalFareWithCCFee)
            ->setTotalEquivFareWithCCFee($totalEquivFareWithCCFee)
            ->setFareConstruction($fareConstruction)
            ->setUnstructuredFareCalc($unstructuredFareCalc)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTicketDesignatorCode($ticketDesignatorCode);
    }
    /**
     * Get BaseFare value
     * @return \StructType\BaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \StructType\BaseFare $baseFare
     * @return \StructType\FareType
     */
    public function setBaseFare(\StructType\BaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \StructType\EquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \StructType\EquivFare $equivFare
     * @return \StructType\FareType
     */
    public function setEquivFare(\StructType\EquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\FareType
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\FareType
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \StructType\TotalFare $totalFare
     * @return \StructType\FareType
     */
    public function setTotalFare(\StructType\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TotalEquivFare value
     * @return \StructType\TotalEquivFare|null
     */
    public function getTotalEquivFare()
    {
        return $this->TotalEquivFare;
    }
    /**
     * Set TotalEquivFare value
     * @param \StructType\TotalEquivFare $totalEquivFare
     * @return \StructType\FareType
     */
    public function setTotalEquivFare(\StructType\TotalEquivFare $totalEquivFare = null)
    {
        $this->TotalEquivFare = $totalEquivFare;
        return $this;
    }
    /**
     * Get TotalFareWithCCFee value
     * @return \StructType\TotalFareWithCCFee|null
     */
    public function getTotalFareWithCCFee()
    {
        return $this->TotalFareWithCCFee;
    }
    /**
     * Set TotalFareWithCCFee value
     * @param \StructType\TotalFareWithCCFee $totalFareWithCCFee
     * @return \StructType\FareType
     */
    public function setTotalFareWithCCFee(\StructType\TotalFareWithCCFee $totalFareWithCCFee = null)
    {
        $this->TotalFareWithCCFee = $totalFareWithCCFee;
        return $this;
    }
    /**
     * Get TotalEquivFareWithCCFee value
     * @return \StructType\TotalEquivFareWithCCFee|null
     */
    public function getTotalEquivFareWithCCFee()
    {
        return $this->TotalEquivFareWithCCFee;
    }
    /**
     * Set TotalEquivFareWithCCFee value
     * @param \StructType\TotalEquivFareWithCCFee $totalEquivFareWithCCFee
     * @return \StructType\FareType
     */
    public function setTotalEquivFareWithCCFee(\StructType\TotalEquivFareWithCCFee $totalEquivFareWithCCFee = null)
    {
        $this->TotalEquivFareWithCCFee = $totalEquivFareWithCCFee;
        return $this;
    }
    /**
     * Get FareConstruction value
     * @return \StructType\FareConstruction|null
     */
    public function getFareConstruction()
    {
        return $this->FareConstruction;
    }
    /**
     * Set FareConstruction value
     * @param \StructType\FareConstruction $fareConstruction
     * @return \StructType\FareType
     */
    public function setFareConstruction(\StructType\FareConstruction $fareConstruction = null)
    {
        $this->FareConstruction = $fareConstruction;
        return $this;
    }
    /**
     * Get UnstructuredFareCalc value
     * @return \StructType\UnstructuredFareCalc|null
     */
    public function getUnstructuredFareCalc()
    {
        return $this->UnstructuredFareCalc;
    }
    /**
     * Set UnstructuredFareCalc value
     * @param \StructType\UnstructuredFareCalc $unstructuredFareCalc
     * @return \StructType\FareType
     */
    public function setUnstructuredFareCalc(\StructType\UnstructuredFareCalc $unstructuredFareCalc = null)
    {
        $this->UnstructuredFareCalc = $unstructuredFareCalc;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\FareType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\FareType
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
