<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Detailed information on individual priced fares | Information used to define a fare and its associated rules information. | Fares and related information for this fare rule. | Detailed information on individual priced fares. |
 * Information used to define a fare and its associated rules information.
 * @subpackage Structs
 */
class FareInfo extends FareInfoType
{
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Date[]
     */
    public $Date;
    /**
     * The Fare
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fare
     */
    public $Fare;
    /**
     * The PTC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PTC[]
     */
    public $PTC;
    /**
     * The FareBasisCode
     * Meta informations extracted from the WSDL
     * - documentation: The fare basis code for the fare for this rule.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The GlobalIndicatorCode
     * Meta informations extracted from the WSDL
     * - documentation: The global direction for this fare rule.
     * - use: optional
     * @var string
     */
    public $GlobalIndicatorCode;
    /**
     * The MaximumPermittedMileage
     * Meta informations extracted from the WSDL
     * - documentation: The maximum mileage (in miles) that can be travelled under this fare.
     * - use: optional
     * @var int
     */
    public $MaximumPermittedMileage;
    /**
     * The TripType
     * Meta informations extracted from the WSDL
     * - documentation: Tthe type of trip associated with the rule.
     * - use: optional
     * @var string
     */
    public $TripType;
    /**
     * The FareType
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the fare type for this fare.
     * - use: optional
     * @var string
     */
    public $FareType;
    /**
     * The PassengerFare
     * Meta informations extracted from the WSDL
     * - documentation: The fare with cost breakdown.
     * @var mixed
     */
    public $PassengerFare;
    /**
     * Constructor method for FareInfo
     * @uses FareInfo::setTPA_Extensions()
     * @uses FareInfo::setDate()
     * @uses FareInfo::setFare()
     * @uses FareInfo::setPTC()
     * @uses FareInfo::setFareBasisCode()
     * @uses FareInfo::setGlobalIndicatorCode()
     * @uses FareInfo::setMaximumPermittedMileage()
     * @uses FareInfo::setTripType()
     * @uses FareInfo::setFareType()
     * @uses FareInfo::setPassengerFare()
     * @param mixed $tPA_Extensions
     * @param \StructType\Date[] $date
     * @param \StructType\Fare $fare
     * @param \StructType\PTC[] $pTC
     * @param string $fareBasisCode
     * @param string $globalIndicatorCode
     * @param int $maximumPermittedMileage
     * @param string $tripType
     * @param string $fareType
     * @param mixed $passengerFare
     */
    public function __construct($tPA_Extensions = null, array $date = array(), \StructType\Fare $fare = null, array $pTC = array(), $fareBasisCode = null, $globalIndicatorCode = null, $maximumPermittedMileage = null, $tripType = null, $fareType = null, $passengerFare = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setDate($date)
            ->setFare($fare)
            ->setPTC($pTC)
            ->setFareBasisCode($fareBasisCode)
            ->setGlobalIndicatorCode($globalIndicatorCode)
            ->setMaximumPermittedMileage($maximumPermittedMileage)
            ->setTripType($tripType)
            ->setFareType($fareType)
            ->setPassengerFare($passengerFare);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\FareInfo
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $date
     * @return \StructType\FareInfo
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $fareInfoDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoDateItem instanceof \StructType\Date) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\Date, "%s" given', is_object($fareInfoDateItem) ? get_class($fareInfoDateItem) : gettype($fareInfoDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\FareInfo
     */
    public function addToDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \StructType\Date, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get Fare value
     * @return \StructType\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \StructType\Fare $fare
     * @return \StructType\FareInfo
     */
    public function setFare(\StructType\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PTC value
     * @return \StructType\PTC[]|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * Set PTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC[] $pTC
     * @return \StructType\FareInfo
     */
    public function setPTC(array $pTC = array())
    {
        foreach ($pTC as $fareInfoPTCItem) {
            // validation for constraint: itemType
            if (!$fareInfoPTCItem instanceof \StructType\PTC) {
                throw new \InvalidArgumentException(sprintf('The PTC property can only contain items of \StructType\PTC, "%s" given', is_object($fareInfoPTCItem) ? get_class($fareInfoPTCItem) : gettype($fareInfoPTCItem)), __LINE__);
            }
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Add item to PTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC $item
     * @return \StructType\FareInfo
     */
    public function addToPTC(\StructType\PTC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTC) {
            throw new \InvalidArgumentException(sprintf('The PTC property can only contain items of \StructType\PTC, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PTC[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get GlobalIndicatorCode value
     * @return string|null
     */
    public function getGlobalIndicatorCode()
    {
        return $this->GlobalIndicatorCode;
    }
    /**
     * Set GlobalIndicatorCode value
     * @param string $globalIndicatorCode
     * @return \StructType\FareInfo
     */
    public function setGlobalIndicatorCode($globalIndicatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($globalIndicatorCode) && !is_string($globalIndicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($globalIndicatorCode)), __LINE__);
        }
        $this->GlobalIndicatorCode = $globalIndicatorCode;
        return $this;
    }
    /**
     * Get MaximumPermittedMileage value
     * @return int|null
     */
    public function getMaximumPermittedMileage()
    {
        return $this->MaximumPermittedMileage;
    }
    /**
     * Set MaximumPermittedMileage value
     * @param int $maximumPermittedMileage
     * @return \StructType\FareInfo
     */
    public function setMaximumPermittedMileage($maximumPermittedMileage = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPermittedMileage) && !is_numeric($maximumPermittedMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumPermittedMileage)), __LINE__);
        }
        $this->MaximumPermittedMileage = $maximumPermittedMileage;
        return $this;
    }
    /**
     * Get TripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @param string $tripType
     * @return \StructType\FareInfo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: string
        if (!is_null($tripType) && !is_string($tripType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tripType)), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\FareInfo
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return mixed|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param mixed $passengerFare
     * @return \StructType\FareInfo
     */
    public function setPassengerFare($passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
