<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Destination StructType
 * Meta informations extracted from the WSDL
 * - documentation: Identifies a single destination point of the traveler(s) journey as well as arrival and departure dates.
 * @subpackage Structs
 */
class Destination extends AddressType
{
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DepartureDate;
    /**
     * Constructor method for Destination
     * @uses Destination::setArrivalDate()
     * @uses Destination::setDepartureDate()
     * @param string $arrivalDate
     * @param string $departureDate
     */
    public function __construct($arrivalDate = null, $departureDate = null)
    {
        $this
            ->setArrivalDate($arrivalDate)
            ->setDepartureDate($departureDate);
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \StructType\Destination
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\Destination
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Destination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
