<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredTravelers StructType
 * Meta informations extracted from the WSDL
 * - documentation: Container for information about the travelers requesting coverage by the insurance plan
 * @subpackage Structs
 */
class CoveredTravelers extends AbstractStructBase
{
    /**
     * The CoveredTraveler
     * Meta informations extracted from the WSDL
     * - documentation: Contains identifying information, coverage requirements and journey information for each individual requesting coverage by the insurance plan.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $CoveredTraveler;
    /**
     * Constructor method for CoveredTravelers
     * @uses CoveredTravelers::setCoveredTraveler()
     * @param mixed[] $coveredTraveler
     */
    public function __construct(array $coveredTraveler = array())
    {
        $this
            ->setCoveredTraveler($coveredTraveler);
    }
    /**
     * Get CoveredTraveler value
     * @return mixed[]|null
     */
    public function getCoveredTraveler()
    {
        return $this->CoveredTraveler;
    }
    /**
     * Set CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $coveredTraveler
     * @return \StructType\CoveredTravelers
     */
    public function setCoveredTraveler(array $coveredTraveler = array())
    {
        foreach ($coveredTraveler as $coveredTravelersCoveredTravelerItem) {
            // validation for constraint: itemType
            if (!false) {
                throw new \InvalidArgumentException(sprintf('The CoveredTraveler property can only contain items of anyType, "%s" given', is_object($coveredTravelersCoveredTravelerItem) ? get_class($coveredTravelersCoveredTravelerItem) : gettype($coveredTravelersCoveredTravelerItem)), __LINE__);
            }
        }
        $this->CoveredTraveler = $coveredTraveler;
        return $this;
    }
    /**
     * Add item to CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoveredTravelers
     */
    public function addToCoveredTraveler($item)
    {
        // validation for constraint: itemType
        if (!false) {
            throw new \InvalidArgumentException(sprintf('The CoveredTraveler property can only contain items of anyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CoveredTraveler[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredTravelers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
