<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveredLuggage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains descriptions of luggage or equipment for which the traveler has requested additional baggage/equipment coverage (if offered by the insurance plan).
 * @subpackage Structs
 */
class CoveredLuggage extends AbstractStructBase
{
    /**
     * The LuggageItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\LuggageItem[]
     */
    public $LuggageItem;
    /**
     * Constructor method for CoveredLuggage
     * @uses CoveredLuggage::setLuggageItem()
     * @param \StructType\LuggageItem[] $luggageItem
     */
    public function __construct(array $luggageItem = array())
    {
        $this
            ->setLuggageItem($luggageItem);
    }
    /**
     * Get LuggageItem value
     * @return \StructType\LuggageItem[]|null
     */
    public function getLuggageItem()
    {
        return $this->LuggageItem;
    }
    /**
     * Set LuggageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LuggageItem[] $luggageItem
     * @return \StructType\CoveredLuggage
     */
    public function setLuggageItem(array $luggageItem = array())
    {
        foreach ($luggageItem as $coveredLuggageLuggageItemItem) {
            // validation for constraint: itemType
            if (!$coveredLuggageLuggageItemItem instanceof \StructType\LuggageItem) {
                throw new \InvalidArgumentException(sprintf('The LuggageItem property can only contain items of \StructType\LuggageItem, "%s" given', is_object($coveredLuggageLuggageItemItem) ? get_class($coveredLuggageLuggageItemItem) : gettype($coveredLuggageLuggageItemItem)), __LINE__);
            }
        }
        $this->LuggageItem = $luggageItem;
        return $this;
    }
    /**
     * Add item to LuggageItem value
     * @throws \InvalidArgumentException
     * @param \StructType\LuggageItem $item
     * @return \StructType\CoveredLuggage
     */
    public function addToLuggageItem(\StructType\LuggageItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LuggageItem) {
            throw new \InvalidArgumentException(sprintf('The LuggageItem property can only contain items of \StructType\LuggageItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LuggageItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveredLuggage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
