<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageLimitType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about the insurance coverage limits that applies to all covered travelers
 * @subpackage Structs
 */
class CoverageLimitType extends AbstractStructBase
{
    /**
     * The CoverageType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the type of coverage or benefit requested by the covered individuals. Refer to OTA Code List Coverage Type (COV).
     * - use: required
     * @var string
     */
    public $CoverageType;
    /**
     * The Deductible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Deductible
     */
    public $Deductible;
    /**
     * The PolicyLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyLimit
     */
    public $PolicyLimit;
    /**
     * The IndividualLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IndividualLimit
     */
    public $IndividualLimit;
    /**
     * The CoverageLevel
     * Meta informations extracted from the WSDL
     * - documentation: Indicates a level of coverage for the plan benefit e.g. Silver, Gold, Platinum
     * - use: optional
     * @var string
     */
    public $CoverageLevel;
    /**
     * The UnlimitedCoverage
     * Meta informations extracted from the WSDL
     * - documentation: Flag to indicate unlimited coverage for the specific benefit is available/requested
     * - use: optional
     * @var bool
     */
    public $UnlimitedCoverage;
    /**
     * The Covered
     * Meta informations extracted from the WSDL
     * - documentation: Flag to indicate coverage type is available/requested
     * - use: optional
     * @var bool
     */
    public $Covered;
    /**
     * Constructor method for CoverageLimitType
     * @uses CoverageLimitType::setCoverageType()
     * @uses CoverageLimitType::setDeductible()
     * @uses CoverageLimitType::setPolicyLimit()
     * @uses CoverageLimitType::setIndividualLimit()
     * @uses CoverageLimitType::setCoverageLevel()
     * @uses CoverageLimitType::setUnlimitedCoverage()
     * @uses CoverageLimitType::setCovered()
     * @param string $coverageType
     * @param \StructType\Deductible $deductible
     * @param \StructType\PolicyLimit $policyLimit
     * @param \StructType\IndividualLimit $individualLimit
     * @param string $coverageLevel
     * @param bool $unlimitedCoverage
     * @param bool $covered
     */
    public function __construct($coverageType = null, \StructType\Deductible $deductible = null, \StructType\PolicyLimit $policyLimit = null, \StructType\IndividualLimit $individualLimit = null, $coverageLevel = null, $unlimitedCoverage = null, $covered = null)
    {
        $this
            ->setCoverageType($coverageType)
            ->setDeductible($deductible)
            ->setPolicyLimit($policyLimit)
            ->setIndividualLimit($individualLimit)
            ->setCoverageLevel($coverageLevel)
            ->setUnlimitedCoverage($unlimitedCoverage)
            ->setCovered($covered);
    }
    /**
     * Get CoverageType value
     * @return string
     */
    public function getCoverageType()
    {
        return $this->CoverageType;
    }
    /**
     * Set CoverageType value
     * @param string $coverageType
     * @return \StructType\CoverageLimitType
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coverageType)), __LINE__);
        }
        $this->CoverageType = $coverageType;
        return $this;
    }
    /**
     * Get Deductible value
     * @return \StructType\Deductible|null
     */
    public function getDeductible()
    {
        return $this->Deductible;
    }
    /**
     * Set Deductible value
     * @param \StructType\Deductible $deductible
     * @return \StructType\CoverageLimitType
     */
    public function setDeductible(\StructType\Deductible $deductible = null)
    {
        $this->Deductible = $deductible;
        return $this;
    }
    /**
     * Get PolicyLimit value
     * @return \StructType\PolicyLimit|null
     */
    public function getPolicyLimit()
    {
        return $this->PolicyLimit;
    }
    /**
     * Set PolicyLimit value
     * @param \StructType\PolicyLimit $policyLimit
     * @return \StructType\CoverageLimitType
     */
    public function setPolicyLimit(\StructType\PolicyLimit $policyLimit = null)
    {
        $this->PolicyLimit = $policyLimit;
        return $this;
    }
    /**
     * Get IndividualLimit value
     * @return \StructType\IndividualLimit|null
     */
    public function getIndividualLimit()
    {
        return $this->IndividualLimit;
    }
    /**
     * Set IndividualLimit value
     * @param \StructType\IndividualLimit $individualLimit
     * @return \StructType\CoverageLimitType
     */
    public function setIndividualLimit(\StructType\IndividualLimit $individualLimit = null)
    {
        $this->IndividualLimit = $individualLimit;
        return $this;
    }
    /**
     * Get CoverageLevel value
     * @return string|null
     */
    public function getCoverageLevel()
    {
        return $this->CoverageLevel;
    }
    /**
     * Set CoverageLevel value
     * @param string $coverageLevel
     * @return \StructType\CoverageLimitType
     */
    public function setCoverageLevel($coverageLevel = null)
    {
        // validation for constraint: string
        if (!is_null($coverageLevel) && !is_string($coverageLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coverageLevel)), __LINE__);
        }
        $this->CoverageLevel = $coverageLevel;
        return $this;
    }
    /**
     * Get UnlimitedCoverage value
     * @return bool|null
     */
    public function getUnlimitedCoverage()
    {
        return $this->UnlimitedCoverage;
    }
    /**
     * Set UnlimitedCoverage value
     * @param bool $unlimitedCoverage
     * @return \StructType\CoverageLimitType
     */
    public function setUnlimitedCoverage($unlimitedCoverage = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlimitedCoverage) && !is_bool($unlimitedCoverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlimitedCoverage)), __LINE__);
        }
        $this->UnlimitedCoverage = $unlimitedCoverage;
        return $this;
    }
    /**
     * Get Covered value
     * @return bool|null
     */
    public function getCovered()
    {
        return $this->Covered;
    }
    /**
     * Set Covered value
     * @param bool $covered
     * @return \StructType\CoverageLimitType
     */
    public function setCovered($covered = null)
    {
        // validation for constraint: boolean
        if (!is_null($covered) && !is_bool($covered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($covered)), __LINE__);
        }
        $this->Covered = $covered;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverageLimitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
